/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.semaphore;

import com.google.common.annotations.VisibleForTesting;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.function.BooleanSupplier;
import org.apache.pulsar.common.semaphore.AsyncDualMemoryLimiter;
import org.apache.pulsar.common.semaphore.AsyncSemaphore;
import org.apache.pulsar.common.semaphore.AsyncSemaphoreImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncDualMemoryLimiterImpl
implements AsyncDualMemoryLimiter,
AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(AsyncDualMemoryLimiterImpl.class);
    private final ScheduledExecutorService executor;
    private final boolean shutdownExecutor;
    private final AsyncSemaphoreImpl heapLimiter;
    private final AsyncSemaphoreImpl directLimiter;

    public AsyncDualMemoryLimiterImpl(long maxHeapMemory, int maxHeapQueueSize, long heapTimeoutMillis, long maxDirectMemory, int maxDirectQueueSize, long directTimeoutMillis, ScheduledExecutorService executor) {
        this(maxHeapMemory, maxHeapQueueSize, heapTimeoutMillis, maxDirectMemory, maxDirectQueueSize, directTimeoutMillis, executor, false);
    }

    public AsyncDualMemoryLimiterImpl(long maxHeapMemory, int maxHeapQueueSize, long heapTimeoutMillis, long maxDirectMemory, int maxDirectQueueSize, long directTimeoutMillis) {
        this(maxHeapMemory, maxHeapQueueSize, heapTimeoutMillis, maxDirectMemory, maxDirectQueueSize, directTimeoutMillis, AsyncDualMemoryLimiterImpl.createExecutor(), true);
    }

    AsyncDualMemoryLimiterImpl(long maxHeapMemory, int maxHeapQueueSize, long heapTimeoutMillis, long maxDirectMemory, int maxDirectQueueSize, long directTimeoutMillis, ScheduledExecutorService executor, boolean shutdownExecutor) {
        this.executor = executor;
        this.shutdownExecutor = shutdownExecutor;
        this.heapLimiter = new AsyncSemaphoreImpl(maxHeapMemory, maxHeapQueueSize, heapTimeoutMillis, executor, this::recordHeapWaitTime);
        this.directLimiter = new AsyncSemaphoreImpl(maxDirectMemory, maxDirectQueueSize, directTimeoutMillis, executor, this::recordDirectWaitTime);
    }

    private static ScheduledExecutorService createExecutor() {
        return Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DefaultThreadFactory("async-dual-memory-limiter"));
    }

    @Override
    public CompletableFuture<AsyncDualMemoryLimiter.AsyncDualMemoryLimiterPermit> acquire(long memorySize, AsyncDualMemoryLimiter.LimitType limitType, BooleanSupplier isCancelled) {
        AsyncSemaphore limiter = this.getLimiter(limitType);
        return limiter.acquire(memorySize, isCancelled).thenApply(result -> new DualMemoryLimiterPermit(limitType, (AsyncSemaphore.AsyncSemaphorePermit)result));
    }

    @VisibleForTesting
    public AsyncSemaphore getLimiter(AsyncDualMemoryLimiter.LimitType limitType) {
        switch (limitType) {
            case HEAP_MEMORY: {
                return this.heapLimiter;
            }
            case DIRECT_MEMORY: {
                return this.directLimiter;
            }
        }
        throw new IllegalArgumentException("Unsupported limit type: " + (Object)((Object)limitType));
    }

    @Override
    public CompletableFuture<AsyncDualMemoryLimiter.AsyncDualMemoryLimiterPermit> update(AsyncDualMemoryLimiter.AsyncDualMemoryLimiterPermit permit, long newMemorySize, BooleanSupplier isCancelled) {
        AsyncSemaphore limiter = this.getLimiter(permit.getLimitType());
        return limiter.update(this.castToImplementation(permit).getUnderlyingPermit(), newMemorySize, isCancelled).thenApply(updatedPermit -> new DualMemoryLimiterPermit(permit.getLimitType(), (AsyncSemaphore.AsyncSemaphorePermit)updatedPermit));
    }

    @Override
    public void release(AsyncDualMemoryLimiter.AsyncDualMemoryLimiterPermit permit) {
        AsyncSemaphore limiter = this.getLimiter(permit.getLimitType());
        limiter.release(this.castToImplementation(permit).getUnderlyingPermit());
    }

    private DualMemoryLimiterPermit castToImplementation(AsyncDualMemoryLimiter.AsyncDualMemoryLimiterPermit permit) {
        if (permit instanceof DualMemoryLimiterPermit) {
            return (DualMemoryLimiterPermit)permit;
        }
        throw new IllegalArgumentException("Invalid permit type");
    }

    protected void recordHeapWaitTime(long waitTimeNanos) {
    }

    protected void recordDirectWaitTime(long waitTimeNanos) {
    }

    @Override
    public void close() {
        this.heapLimiter.close();
        this.directLimiter.close();
        if (this.shutdownExecutor) {
            this.executor.shutdown();
        }
    }

    private static class DualMemoryLimiterPermit
    implements AsyncDualMemoryLimiter.AsyncDualMemoryLimiterPermit {
        private final AsyncDualMemoryLimiter.LimitType limitType;
        private final AsyncSemaphore.AsyncSemaphorePermit underlyingPermit;

        DualMemoryLimiterPermit(AsyncDualMemoryLimiter.LimitType limitType, AsyncSemaphore.AsyncSemaphorePermit underlyingPermit) {
            this.limitType = limitType;
            this.underlyingPermit = underlyingPermit;
        }

        @Override
        public long getPermits() {
            return this.underlyingPermit.getPermits();
        }

        @Override
        public AsyncDualMemoryLimiter.LimitType getLimitType() {
            return this.limitType;
        }

        public AsyncSemaphore.AsyncSemaphorePermit getUnderlyingPermit() {
            return this.underlyingPermit;
        }

        public String toString() {
            return "DualMemoryLimiterPermit@" + System.identityHashCode(this) + "{limitType=" + (Object)((Object)this.limitType) + ", permits=" + this.underlyingPermit.getPermits() + '}';
        }
    }
}

