/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client;

import java.io.File;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.constant.PermName;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.topic.TopicValidator;

public class Validators {
    public static final int CHARACTER_MAX_LENGTH = 255;
    public static final int TOPIC_MAX_LENGTH = 127;
    public static final int GROUP_MAX_LENGTH = 120;

    public static void checkGroup(String group) throws MQClientException {
        if (UtilAll.isBlank((String)group)) {
            throw new MQClientException("the specified group is blank", null);
        }
        if (group.length() > 120) {
            throw new MQClientException(String.format("the specified group[%s] is longer than group max length: %s.", group, 120), null);
        }
        if (TopicValidator.isTopicOrGroupIllegal((String)group)) {
            throw new MQClientException(String.format("the specified group[%s] contains illegal characters, allowing only %s", group, "^[%|a-zA-Z0-9_-]+$"), null);
        }
    }

    public static void checkMessage(Message msg, DefaultMQProducer defaultMQProducer) throws MQClientException {
        if (null == msg) {
            throw new MQClientException(13, "the message is null");
        }
        Validators.checkTopic(msg.getTopic());
        Validators.isNotAllowedSendTopic(msg.getTopic());
        if (null == msg.getBody()) {
            throw new MQClientException(13, "the message body is null");
        }
        if (0 == msg.getBody().length) {
            throw new MQClientException(13, "the message body length is zero");
        }
        if (msg.getBody().length > defaultMQProducer.getMaxMessageSize()) {
            throw new MQClientException(13, "the message body size over max value, MAX: " + defaultMQProducer.getMaxMessageSize());
        }
        String lmqPath = msg.getUserProperty("INNER_MULTI_DISPATCH");
        if (StringUtils.contains((CharSequence)lmqPath, (CharSequence)File.separator)) {
            throw new MQClientException(13, "INNER_MULTI_DISPATCH " + lmqPath + " can not contains " + File.separator + " character");
        }
    }

    public static void checkTopic(String topic) throws MQClientException {
        if (UtilAll.isBlank((String)topic)) {
            throw new MQClientException("The specified topic is blank", null);
        }
        if (topic.length() > 127) {
            throw new MQClientException(String.format("The specified topic is longer than topic max length %d.", 127), null);
        }
        if (TopicValidator.isTopicOrGroupIllegal((String)topic)) {
            throw new MQClientException(String.format("The specified topic[%s] contains illegal characters, allowing only %s", topic, "^[%|a-zA-Z0-9_-]+$"), null);
        }
    }

    public static void isSystemTopic(String topic) throws MQClientException {
        if (TopicValidator.isSystemTopic((String)topic)) {
            throw new MQClientException(String.format("The topic[%s] is conflict with system topic.", topic), null);
        }
    }

    public static void isNotAllowedSendTopic(String topic) throws MQClientException {
        if (TopicValidator.isNotAllowedSendTopic((String)topic)) {
            throw new MQClientException(String.format("Sending message to topic[%s] is forbidden.", topic), null);
        }
    }

    public static void checkTopicConfig(TopicConfig topicConfig) throws MQClientException {
        if (!PermName.isValid((int)topicConfig.getPerm())) {
            throw new MQClientException(16, String.format("topicPermission value: %s is invalid.", topicConfig.getPerm()));
        }
    }

    public static void checkBrokerConfig(Properties brokerConfig) throws MQClientException {
        if (brokerConfig.containsKey("brokerPermission") && !PermName.isValid((String)brokerConfig.getProperty("brokerPermission"))) {
            throw new MQClientException(16, String.format("brokerPermission value: %s is invalid.", brokerConfig.getProperty("brokerPermission")));
        }
    }
}

