/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rpc;

import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.rpc.RpcRequests;
import com.google.protobuf.Message;

public interface RpcResponseFactory {
    public static final int ERROR_RESPONSE_NUM = 99;

    default public Message newResponse(Message parent, Status st) {
        if (st == null) {
            return this.newResponse(parent, 0, "OK", new Object[0]);
        }
        return this.newResponse(parent, st.getCode(), st.getErrorMsg(), new Object[0]);
    }

    default public Message newResponse(Message parent, RaftError error, String fmt, Object ... args) {
        return this.newResponse(parent, error.getNumber(), fmt, args);
    }

    default public Message newResponse(Message parent, int code, String fmt, Object ... args) {
        RpcRequests.ErrorResponse.Builder eBuilder = RpcRequests.ErrorResponse.newBuilder();
        eBuilder.setErrorCode(code);
        if (fmt != null) {
            eBuilder.setErrorMsg(String.format(fmt, args));
        }
        return eBuilder.build();
    }
}

