/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.it.testing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.junit.Activator;
import org.apache.sling.junit.rules.TeleporterRule;
import org.apache.sling.models.factory.ModelFactory;
import org.apache.sling.models.it.testbundle.models.ServiceInjectionTestModel;
import org.apache.sling.models.it.testbundle.services.SimpleService;
import org.apache.sling.models.it.testbundle.services.SimpleServiceWithCustomRanking;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class ServiceInjectionWithDifferentRankingIT {
    @Rule
    public final TeleporterRule teleporter = TeleporterRule.forClass(this.getClass(), (String)"SM_Teleporter");
    private ModelFactory modelFactory;
    private String value;
    private ResourceResolver resolver;
    private Resource resource;
    private Node createdNode;
    private BundleContext bundleContext;
    private Collection<ServiceRegistration> serviceRegistrations;

    @Before
    public void setUp() throws Exception {
        ResourceResolverFactory rrFactory = (ResourceResolverFactory)this.teleporter.getService(ResourceResolverFactory.class);
        this.modelFactory = (ModelFactory)this.teleporter.getService(ModelFactory.class);
        this.value = RandomStringUtils.secure().nextAlphanumeric(10);
        this.resolver = rrFactory.getServiceResourceResolver(null);
        Session session = (Session)this.resolver.adaptTo(Session.class);
        Node rootNode = session.getRootNode();
        this.createdNode = rootNode.addNode("test_" + RandomStringUtils.secure().nextAlphanumeric(10));
        this.createdNode.setProperty("testProperty", this.value);
        session.save();
        this.resource = this.resolver.getResource(this.createdNode.getPath());
        this.bundleContext = Activator.getBundleContext();
        this.serviceRegistrations = new ArrayList<ServiceRegistration>();
    }

    @After
    public void tearDown() throws Exception {
        if (this.createdNode != null) {
            this.createdNode.remove();
        }
        if (this.resolver != null) {
            this.resolver.close();
        }
        for (ServiceRegistration serviceRegistration : this.serviceRegistrations) {
            serviceRegistration.unregister();
        }
    }

    private void registerSimpleService(int ranking) {
        Hashtable<String, Integer> serviceProps = new Hashtable<String, Integer>();
        ((Dictionary)serviceProps).put("service.ranking", new Integer(ranking));
        ServiceRegistration serviceRegistration = this.bundleContext.registerService(SimpleService.class.getName(), (Object)new SimpleServiceWithCustomRanking(ranking), serviceProps);
        this.serviceRegistrations.add(serviceRegistration);
    }

    @Test
    public void testServiceInjectionConsideringRankingWithResource() {
        this.registerSimpleService(0);
        ServiceInjectionTestModel model = (ServiceInjectionTestModel)this.modelFactory.createModel((Object)this.resource, ServiceInjectionTestModel.class);
        Assert.assertNotNull((String)"Model is null", (Object)model);
        Assert.assertEquals((String)"The service with the highest ranking was not returned", (long)0L, (long)model.getSimpleService().getRanking());
        Assert.assertArrayEquals((String)"Order on injected services is wrong", (Object[])model.getSimpleServicesRankings(), (Object[])new Integer[]{0});
        this.registerSimpleService(-1000);
        model = (ServiceInjectionTestModel)this.modelFactory.createModel((Object)this.resource, ServiceInjectionTestModel.class);
        Assert.assertNotNull((String)"Model is null", (Object)model);
        Assert.assertEquals((String)"The service with the highest ranking was not returned", (long)0L, (long)model.getSimpleService().getRanking());
        Assert.assertArrayEquals((String)"Order on injected services is wrong", (Object[])model.getSimpleServicesRankings(), (Object[])new Integer[]{0, -1000});
        this.registerSimpleService(1000);
        model = (ServiceInjectionTestModel)this.modelFactory.createModel((Object)this.resource, ServiceInjectionTestModel.class);
        Assert.assertNotNull((String)"Model is null", (Object)model);
        Assert.assertEquals((String)"The service with the highest ranking was not returned", (long)1000L, (long)model.getSimpleService().getRanking());
        Assert.assertArrayEquals((String)"Order on injected services is wrong", (Object[])model.getSimpleServicesRankings(), (Object[])new Integer[]{1000, 0, -1000});
    }
}

