/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling;

import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.apache.sling.testing.mock.sling.MockJcrSlingRepository;
import org.apache.sling.testing.mock.sling.MockSling;
import org.apache.sling.testing.mock.sling.NodeTypeMode;
import org.apache.sling.testing.mock.sling.spi.ResourceResolverTypeAdapter;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.BundleContext;

public class MockSlingTest {
    private SlingRepository buildRepo(ResourceResolverTypeAdapter adapter) {
        BundleContext context = MockOsgi.newBundleContext();
        MockSling.buildFactoryFromRepository((NodeTypeMode)NodeTypeMode.NOT_SUPPORTED, (BundleContext)context, (ResourceResolverTypeAdapter)adapter);
        return (SlingRepository)context.getService(context.getServiceReference(SlingRepository.class));
    }

    @Test
    public void testAdapterDoesNotSupportSnapshots() {
        ResourceResolverTypeAdapter snapshotUnawareAdapter = new ResourceResolverTypeAdapter(){

            @Nullable
            public ResourceResolverFactory newResourceResolverFactory() {
                return null;
            }

            public SlingRepository newSlingRepository() {
                return new MockJcrSlingRepository();
            }
        };
        SlingRepository repo1 = this.buildRepo(snapshotUnawareAdapter);
        SlingRepository repo2 = this.buildRepo(snapshotUnawareAdapter);
        Assert.assertNotNull((Object)repo1);
        Assert.assertNotNull((Object)repo2);
        Assert.assertNotSame((Object)repo2, (Object)repo1);
    }

    @Test
    public void testAdapterSupportsSnapshots() {
        MockJcrSlingRepository freshRepo = new MockJcrSlingRepository();
        MockJcrSlingRepository snapshotRepo = new MockJcrSlingRepository();
        ResourceResolverTypeAdapter snapshotAwareAdapter = new ResourceResolverTypeAdapter(){
            final /* synthetic */ SlingRepository val$freshRepo;
            final /* synthetic */ SlingRepository val$snapshotRepo;
            {
                this.val$freshRepo = slingRepository;
                this.val$snapshotRepo = slingRepository2;
            }

            @Nullable
            public ResourceResolverFactory newResourceResolverFactory() {
                return null;
            }

            public SlingRepository newSlingRepository() {
                return this.val$freshRepo;
            }

            public Object snapshot(SlingRepository repository) {
                return "dummy";
            }

            public SlingRepository newSlingRepositoryFromSnapshot(Object snapshot) {
                return this.val$snapshotRepo;
            }
        };
        SlingRepository repo1 = this.buildRepo(snapshotAwareAdapter);
        SlingRepository repo2 = this.buildRepo(snapshotAwareAdapter);
        Assert.assertSame((Object)freshRepo, (Object)repo1);
        Assert.assertSame((Object)snapshotRepo, (Object)repo2);
    }
}

