/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.upgrade;

import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.syncope.core.persistence.jpa.upgrade.GenerateUpgradeSQL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;

@SpringBootApplication(exclude={DataSourceAutoConfiguration.class})
public class SyncopeCorePersistenceJPAUpgrader
implements CommandLineRunner {
    private static final Logger LOG = LoggerFactory.getLogger(SyncopeCorePersistenceJPAUpgrader.class);
    @Autowired
    private GenerateUpgradeSQL generateUpgradeSQL;

    public static void main(String[] args) {
        SpringApplication.run(SyncopeCorePersistenceJPAUpgrader.class, (String[])args);
    }

    public void run(String ... args) throws Exception {
        Writer out;
        if (args.length > 0) {
            LOG.info("Sending upgrade statements to {}", (Object)args[0]);
            out = Files.newBufferedWriter(Path.of(args[0], new String[0]), StandardCharsets.UTF_8, new OpenOption[0]);
        } else {
            LOG.info("Sending upgrade statements to stdout");
            out = new PrintWriter(System.out);
        }
        this.generateUpgradeSQL.run(out);
    }
}

