/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Collections;
import org.apache.kafka.common.message.GetTelemetrySubscriptionsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.GetTelemetrySubscriptionsResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GetTelemetrySubscriptionsResponseTest {
    @Test
    public void testErrorCountsReturnsNoneWhenNoErrors() {
        GetTelemetrySubscriptionsResponseData data = new GetTelemetrySubscriptionsResponseData().setErrorCode(Errors.NONE.code());
        GetTelemetrySubscriptionsResponse response = new GetTelemetrySubscriptionsResponse(data);
        Assertions.assertEquals(Collections.singletonMap(Errors.NONE, 1), (Object)response.errorCounts());
    }

    @Test
    public void testErrorCountsReturnsOneError() {
        GetTelemetrySubscriptionsResponseData data = new GetTelemetrySubscriptionsResponseData().setErrorCode(Errors.CLUSTER_AUTHORIZATION_FAILED.code());
        data.setErrorCode(Errors.INVALID_CONFIG.code());
        GetTelemetrySubscriptionsResponse response = new GetTelemetrySubscriptionsResponse(data);
        Assertions.assertEquals(Collections.singletonMap(Errors.INVALID_CONFIG, 1), (Object)response.errorCounts());
    }
}

