/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.db;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.db.SchemaManager;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaOperationsEngineBuild
implements Command<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaOperationsEngineBuild.class);
    protected final String engineScopeType;
    protected final String schemaOperation;

    public SchemaOperationsEngineBuild(String engineScopeType) {
        this(engineScopeType, null);
    }

    public SchemaOperationsEngineBuild(String engineScopeType, String schemaOperation) {
        this.engineScopeType = engineScopeType;
        this.schemaOperation = schemaOperation;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        AbstractEngineConfiguration engineConfiguration = commandContext.getEngineConfigurations().get(this.engineScopeType);
        if (engineConfiguration == null) {
            throw new FlowableIllegalArgumentException("There is no engine configuration for scope " + this.engineScopeType);
        }
        String databaseSchemaUpdate = this.schemaOperation == null ? engineConfiguration.getDatabaseSchemaUpdate() : this.schemaOperation;
        ArrayList<SchemaManager> schemaManagers = new ArrayList<SchemaManager>();
        if (engineConfiguration.getCommonSchemaManager() != null) {
            schemaManagers.add(engineConfiguration.getCommonSchemaManager());
        }
        schemaManagers.add(engineConfiguration.getSchemaManager());
        Map<String, SchemaManager> additionalSchemaManagers = engineConfiguration.getAdditionalSchemaManagers();
        if (additionalSchemaManagers != null) {
            schemaManagers.addAll(additionalSchemaManagers.values());
        }
        this.executeSchemaUpdate(schemaManagers, databaseSchemaUpdate);
        return null;
    }

    protected void executeSchemaUpdate(List<SchemaManager> schemaManagers, String databaseSchemaUpdate) {
        LOGGER.debug("Executing schema management with setting {} from engine {}", (Object)databaseSchemaUpdate, (Object)this.engineScopeType);
        if ("drop-create".equals(databaseSchemaUpdate)) {
            ListIterator<SchemaManager> listIterator = schemaManagers.listIterator(schemaManagers.size());
            while (listIterator.hasPrevious()) {
                SchemaManager schemaManager = listIterator.previous();
                try {
                    schemaManager.schemaDrop();
                }
                catch (RuntimeException runtimeException) {}
            }
        }
        if ("create-drop".equals(databaseSchemaUpdate) || "drop-create".equals(databaseSchemaUpdate) || "create".equals(databaseSchemaUpdate)) {
            schemaManagers.forEach(SchemaManager::schemaCreate);
        } else if ("false".equals(databaseSchemaUpdate)) {
            schemaManagers.forEach(SchemaManager::schemaCheckVersion);
        } else if ("true".equals(databaseSchemaUpdate)) {
            schemaManagers.forEach(SchemaManager::schemaUpdate);
        }
    }
}

