/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.starter.gauth;

import java.time.LocalDateTime;
import org.apache.syncope.common.lib.wa.GoogleMfaAuthToken;
import org.apache.syncope.common.rest.api.service.wa.GoogleMfaAuthTokenService;
import org.apache.syncope.wa.bootstrap.WARestClient;
import org.apereo.cas.gauth.token.GoogleAuthenticatorToken;
import org.apereo.cas.otp.repository.token.BaseOneTimeTokenRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WAGoogleMfaAuthTokenRepository
extends BaseOneTimeTokenRepository<GoogleAuthenticatorToken> {
    protected static final Logger LOG = LoggerFactory.getLogger(WAGoogleMfaAuthTokenRepository.class);
    protected final WARestClient waRestClient;
    protected final long expireTokensInSeconds;

    public WAGoogleMfaAuthTokenRepository(WARestClient waRestClient, long expireTokensInSeconds) {
        this.waRestClient = waRestClient;
        this.expireTokensInSeconds = expireTokensInSeconds;
    }

    protected void cleanInternal() {
        ((GoogleMfaAuthTokenService)this.waRestClient.getService(GoogleMfaAuthTokenService.class)).delete(LocalDateTime.now().minusSeconds(this.expireTokensInSeconds));
    }

    public GoogleAuthenticatorToken store(GoogleAuthenticatorToken token) {
        GoogleMfaAuthToken tokenTO = new GoogleMfaAuthToken.Builder().token(token.getToken().intValue()).issueDate(token.getIssuedDateTime()).build();
        ((GoogleMfaAuthTokenService)this.waRestClient.getService(GoogleMfaAuthTokenService.class)).store(token.getUserId(), tokenTO);
        return token;
    }

    public GoogleAuthenticatorToken get(String username, Integer otp) {
        try {
            GoogleMfaAuthToken tokenTO = ((GoogleMfaAuthTokenService)this.waRestClient.getService(GoogleMfaAuthTokenService.class)).read(username, otp.intValue());
            GoogleAuthenticatorToken token = new GoogleAuthenticatorToken(Integer.valueOf(tokenTO.getOtp()), username);
            token.setIssuedDateTime(tokenTO.getIssueDate());
            return token;
        }
        catch (Exception e) {
            LOG.debug("Unable to fetch token {} for user {}", (Object)otp, (Object)username);
            return null;
        }
    }

    public void remove(String username, Integer otp) {
        ((GoogleMfaAuthTokenService)this.waRestClient.getService(GoogleMfaAuthTokenService.class)).delete(username, otp.intValue());
    }

    public void remove(String username) {
        ((GoogleMfaAuthTokenService)this.waRestClient.getService(GoogleMfaAuthTokenService.class)).delete(username);
    }

    public void remove(Integer otp) {
        ((GoogleMfaAuthTokenService)this.waRestClient.getService(GoogleMfaAuthTokenService.class)).delete(otp.intValue());
    }

    public void removeAll() {
        ((GoogleMfaAuthTokenService)this.waRestClient.getService(GoogleMfaAuthTokenService.class)).delete((LocalDateTime)null);
    }

    public long count(String username) {
        return ((GoogleMfaAuthTokenService)this.waRestClient.getService(GoogleMfaAuthTokenService.class)).read(username).getTotalCount();
    }

    public long count() {
        return ((GoogleMfaAuthTokenService)this.waRestClient.getService(GoogleMfaAuthTokenService.class)).list().getTotalCount();
    }
}

