/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web;

import java.io.Serializable;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpMessage
implements Serializable {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpMessage.class);
    private static final long serialVersionUID = 2015460875654586133L;
    private static final boolean DEFAULT_ASYNCHRONOUS_CALLBACKS_ENABLED = true;
    private final URL url;
    private final String message;
    private final boolean asynchronous;
    private int responseCode;
    private String contentType = "application/x-www-form-urlencoded";

    public HttpMessage(URL url, String message) {
        this(url, message, true);
    }

    protected String formatOutputMessageInternal(String message) {
        try {
            return URLEncoder.encode(message, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            String msg = String.format("Unable to encode URL %s", message);
            LOGGER.warn(msg, (Throwable)e);
            return message;
        }
    }

    public String getMessage() {
        return this.formatOutputMessageInternal(this.message);
    }

    @Generated
    public String toString() {
        return "HttpMessage(url=" + String.valueOf(this.url) + ", message=" + this.message + ", asynchronous=" + this.asynchronous + ", responseCode=" + this.responseCode + ", contentType=" + this.contentType + ")";
    }

    @Generated
    public URL getUrl() {
        return this.url;
    }

    @Generated
    public boolean isAsynchronous() {
        return this.asynchronous;
    }

    @Generated
    public int getResponseCode() {
        return this.responseCode;
    }

    @Generated
    public String getContentType() {
        return this.contentType;
    }

    @Generated
    public void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    @Generated
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Generated
    public HttpMessage(URL url, String message, boolean asynchronous) {
        this.url = url;
        this.message = message;
        this.asynchronous = asynchronous;
    }
}

