/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.util.CasVersion;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.CasWebSecurityConfigurer;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springdoc.core.properties.SwaggerUiConfigProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ScopedProxyMode;

@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.Discovery})
@AutoConfiguration
public class CasSwaggerAutoConfiguration {
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"casSwaggerEndpointConfigurer"})
    public CasWebSecurityConfigurer<Void> casSwaggerEndpointConfigurer(SwaggerUiConfigProperties swaggerUiConfigProperties, final SpringDocConfigProperties springDocConfigProperties) {
        return new CasWebSecurityConfigurer<Void>(this){

            public List<String> getIgnoredEndpoints() {
                String apiDocs = (String)StringUtils.defaultIfBlank((CharSequence)springDocConfigProperties.getApiDocs().getPath(), (CharSequence)"/v3/api-docs");
                return List.of(apiDocs, "/swagger-ui/", "/swagger-ui.html");
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean(name={"casSwaggerOpenApi"})
    public OpenAPI casSwaggerOpenApi() {
        return new OpenAPI().info(new Info().title("Apereo CAS Swagger API Documentation").description("Apereo CAS Swagger API Documentation").version(CasVersion.asString()).license(new License().name("Apache 2.0").url("https://github.com/apereo/cas/blob/master/LICENSE"))).externalDocs(new ExternalDocumentation().description("Apereo CAS Documentation").url("https://apereo.github.com/cas"));
    }
}

