/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.widgets;

import de.agilecoders.wicket.core.markup.html.bootstrap.image.Icon;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AlertWidget
extends Panel {
    private static final long serialVersionUID = 7667120094526529934L;
    protected static final Logger LOG = LoggerFactory.getLogger(AlertWidget.class);
    protected final Label linkAlertsNumber;
    protected final Label headerAlertsNumber;

    public AlertWidget(String id) {
        super(id);
        this.setOutputMarkupId(true);
        LoadableDetachableModel<Long> size = new LoadableDetachableModel<Long>(){
            private static final long serialVersionUID = 7474274077691068779L;

            protected Long load() {
                return AlertWidget.this.getLatestAlertsSize();
            }
        };
        this.add(new Component[]{this.getIcon("icon")});
        this.linkAlertsNumber = new Label("alerts", (IModel)size){
            private static final long serialVersionUID = 4755868673082976208L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                boolean warning = false;
                try {
                    warning = Integer.parseInt(this.getDefaultModelObject().toString()) > 0;
                }
                catch (Exception e) {
                    LOG.error("Invalid value found: {}", this.getDefaultModelObject(), (Object)e);
                }
                if (warning) {
                    tag.put("class", (CharSequence)"navbar-badge badge text-bg-danger");
                } else {
                    tag.put("class", (CharSequence)"navbar-badge badge text-bg-success");
                }
            }
        };
        this.add(new Component[]{this.linkAlertsNumber.setOutputMarkupId(true)});
        this.headerAlertsNumber = new Label("number", (IModel)size);
        this.add(new Component[]{this.headerAlertsNumber.setOutputMarkupId(true)});
        this.add(new Component[]{this.getEventsLink("alertsLink")});
    }

    protected abstract long getLatestAlertsSize();

    protected abstract AbstractLink getEventsLink(String var1);

    protected abstract Icon getIcon(String var1);

    public static class AlertLink<T>
    extends Panel {
        private static final long serialVersionUID = -6011939604125512766L;

        public AlertLink(String id, T alert) {
            super(id);
            this.add(new Component[]{new Label("alert", (Serializable)((Object)alert.toString()))});
        }
    }
}

