/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.cipher;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.cipher.AbstractCipherExecutor;
import org.apereo.cas.util.crypto.DecryptionException;
import org.apereo.cas.util.crypto.PropertyBoundCipherExecutor;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.gen.Base64RandomStringGenerator;
import org.jooq.lambda.Unchecked;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.OctJwkGenerator;
import org.jose4j.jwk.OctetSequenceJsonWebKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseBinaryCipherExecutor
extends AbstractCipherExecutor<byte[], byte[]>
implements PropertyBoundCipherExecutor<byte[], byte[]> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseBinaryCipherExecutor.class);
    private static final int GCM_TAG_LENGTH = 128;
    private static final int MINIMUM_ENCRYPTION_KEY_LENGTH = 32;
    private static final String CIPHER_ALGORITHM = "AES/GCM/NoPadding";
    protected String cipherName;
    private SecretKeySpec encryptionKey;
    private AlgorithmParameterSpec parameterSpec;
    private String secretKeyAlgorithm = "AES";
    private byte[] encryptionSecretKey;
    private boolean signingEnabled = true;

    protected BaseBinaryCipherExecutor(String encryptionSecretKey, String signingSecretKey, int signingKeySize, int encryptionKeySize, String cipherName) {
        this.cipherName = cipherName;
        try (ExecutorService executor = Executors.newVirtualThreadPerTaskExecutor();){
            Runnable signingCertTask = Unchecked.runnable(() -> this.ensureSigningKeyExists(signingSecretKey, signingKeySize));
            Runnable encryptionCertTask = Unchecked.runnable(() -> this.ensureEncryptionKeyExists(encryptionSecretKey, encryptionKeySize));
            executor.execute(signingCertTask);
            executor.execute(encryptionCertTask);
        }
        this.encryptionKey = new SecretKeySpec(this.encryptionSecretKey, this.secretKeyAlgorithm);
        this.parameterSpec = this.buildParameterSpec(encryptionKeySize);
    }

    private static String generateOctetJsonWebKeyOfSize(int size) {
        OctetSequenceJsonWebKey octetKey = OctJwkGenerator.generateJwk((int)size);
        Map params = octetKey.toParams(JsonWebKey.OutputControlLevel.INCLUDE_SYMMETRIC);
        return params.get("k").toString();
    }

    public byte[] encode(byte[] value, Object[] parameters) {
        return (byte[])FunctionUtils.doUnchecked(() -> {
            Cipher aesCipher = Cipher.getInstance(CIPHER_ALGORITHM);
            aesCipher.init(1, (Key)this.encryptionKey, this.parameterSpec);
            byte[] result = aesCipher.doFinal(value);
            return this.signingEnabled ? this.sign(result, this.getSigningKey()) : result;
        });
    }

    public byte[] decode(byte[] value, Object[] parameters) {
        try {
            byte[] verifiedValue = this.signingEnabled ? this.verifySignature(value, this.getSigningKey()) : value;
            Cipher aesCipher = Cipher.getInstance(CIPHER_ALGORITHM);
            aesCipher.init(2, (Key)this.encryptionKey, this.parameterSpec);
            return aesCipher.doFinal(verifiedValue);
        }
        catch (Exception e) {
            throw LOGGER.isTraceEnabled() ? new DecryptionException(e) : new DecryptionException();
        }
    }

    public PropertyBoundCipherExecutor<byte[], byte[]> withSigningDisabled() {
        BaseBinaryCipherExecutor cipher = new BaseBinaryCipherExecutor(this){};
        cipher.setCipherName(this.getCipherName());
        cipher.setEncryptionKey(this.getEncryptionKey());
        cipher.setParameterSpec(this.getParameterSpec());
        cipher.setCommonHeaders(this.getCommonHeaders());
        cipher.setEncryptionOpHeaders(this.getEncryptionOpHeaders());
        cipher.setEncryptionSecretKey(this.getEncryptionSecretKey());
        cipher.setSecretKeyAlgorithm(this.getSecretKeyAlgorithm());
        cipher.setSigningEnabled(false);
        cipher.setSigningKey(this.getSigningKey());
        cipher.setSigningOpHeaders(this.getSigningOpHeaders());
        cipher.setSigningAlgorithm(this.getSigningAlgorithm());
        return cipher;
    }

    private AlgorithmParameterSpec buildParameterSpec(int encryptionKeySize) {
        byte[] iv = new byte[this.encryptionSecretKey.length];
        if (encryptionKeySize > 32) {
            System.arraycopy(this.encryptionSecretKey, 0, iv, 0, this.encryptionSecretKey.length);
            return new GCMParameterSpec(128, iv);
        }
        return new IvParameterSpec(iv);
    }

    private void ensureEncryptionKeyExists(String encryptionSecretKey, int encryptionKeySize) {
        byte[] genEncryptionKey;
        if (StringUtils.isBlank((CharSequence)encryptionSecretKey)) {
            LOGGER.warn("Secret key for encryption is undefined under [{}]. CAS will attempt to auto-generate the encryption key", (Object)this.getEncryptionKeySetting());
            if (encryptionKeySize <= 32) {
                String key = new Base64RandomStringGenerator(encryptionKeySize).getNewString();
                String prop = String.format("%s=%s", this.getEncryptionKeySetting(), key);
                BaseBinaryCipherExecutor.issueWarningToAddKeyToSettings("encryption", encryptionKeySize, key, prop);
                genEncryptionKey = EncodingUtils.decodeBase64(key);
            } else {
                KeyGenerator keyGenerator = (KeyGenerator)FunctionUtils.doUnchecked(() -> KeyGenerator.getInstance(this.secretKeyAlgorithm));
                keyGenerator.init(encryptionKeySize);
                SecretKey secretKey = keyGenerator.generateKey();
                genEncryptionKey = secretKey.getEncoded();
                String encodedKey = EncodingUtils.encodeBase64(genEncryptionKey);
                String prop = String.format("%s=%s", this.getEncryptionKeySetting(), encodedKey);
                BaseBinaryCipherExecutor.issueWarningToAddKeyToSettings("encryption", encryptionKeySize, encodedKey, prop);
            }
        } else if (encryptionKeySize <= 32) {
            byte[] key;
            boolean base64 = EncodingUtils.isBase64(encryptionSecretKey);
            byte[] byArray = key = base64 ? EncodingUtils.decodeBase64(encryptionSecretKey) : ArrayUtils.EMPTY_BYTE_ARRAY;
            if (base64 && key.length == encryptionKeySize) {
                LOGGER.trace("Secret key for encryption defined under [{}] is Base64 encoded.", (Object)this.getEncryptionKeySetting());
                genEncryptionKey = key;
            } else if (encryptionSecretKey.length() != encryptionKeySize) {
                LOGGER.warn("Secret key for encryption defined under [{}] is Base64 encoded but the size does not match the key size [{}].", (Object)this.getEncryptionKeySetting(), (Object)encryptionKeySize);
                genEncryptionKey = encryptionSecretKey.getBytes(StandardCharsets.UTF_8);
            } else {
                LOGGER.warn("Secret key for encryption defined under [{}] is not Base64 encoded. Clear the setting to regenerate (Recommended) or replace with [{}].", (Object)this.getEncryptionKeySetting(), (Object)EncodingUtils.encodeBase64(encryptionSecretKey));
                genEncryptionKey = encryptionSecretKey.getBytes(StandardCharsets.UTF_8);
            }
        } else {
            genEncryptionKey = EncodingUtils.decodeBase64(encryptionSecretKey);
        }
        this.encryptionSecretKey = genEncryptionKey;
    }

    private void ensureSigningKeyExists(String signingSecretKey, int signingKeySize) {
        String signingKeyToUse = signingSecretKey;
        if (StringUtils.isBlank((CharSequence)signingKeyToUse)) {
            LOGGER.warn("Secret key for signing is not defined under [{}]. CAS will attempt to auto-generate the signing key", (Object)this.getSigningKeySetting());
            signingKeyToUse = BaseBinaryCipherExecutor.generateOctetJsonWebKeyOfSize(signingKeySize);
            String prop = String.format("%s=%s", this.getSigningKeySetting(), signingKeyToUse);
            BaseBinaryCipherExecutor.issueWarningToAddKeyToSettings("signing", signingKeySize, signingKeyToUse, prop);
        }
        this.configureSigningKey(signingKeyToUse);
    }

    private static void issueWarningToAddKeyToSettings(String keyType, int encryptionKeySize, String key, String prop) {
        LOGGER.warn("Generated {} key [{}] of size [{}]. The generated key MUST be added to CAS settings:\n\n\t{}\n\n", new Object[]{keyType, key, encryptionKeySize, prop});
    }

    @Generated
    public String getCipherName() {
        return this.cipherName;
    }

    @Generated
    public SecretKeySpec getEncryptionKey() {
        return this.encryptionKey;
    }

    @Generated
    public AlgorithmParameterSpec getParameterSpec() {
        return this.parameterSpec;
    }

    @Generated
    public String getSecretKeyAlgorithm() {
        return this.secretKeyAlgorithm;
    }

    @Generated
    public byte[] getEncryptionSecretKey() {
        return this.encryptionSecretKey;
    }

    @Generated
    public boolean isSigningEnabled() {
        return this.signingEnabled;
    }

    @Generated
    public BaseBinaryCipherExecutor setCipherName(String cipherName) {
        this.cipherName = cipherName;
        return this;
    }

    @Generated
    public BaseBinaryCipherExecutor setEncryptionKey(SecretKeySpec encryptionKey) {
        this.encryptionKey = encryptionKey;
        return this;
    }

    @Generated
    public BaseBinaryCipherExecutor setParameterSpec(AlgorithmParameterSpec parameterSpec) {
        this.parameterSpec = parameterSpec;
        return this;
    }

    @Generated
    public BaseBinaryCipherExecutor setSecretKeyAlgorithm(String secretKeyAlgorithm) {
        this.secretKeyAlgorithm = secretKeyAlgorithm;
        return this;
    }

    @Generated
    public BaseBinaryCipherExecutor setEncryptionSecretKey(byte[] encryptionSecretKey) {
        this.encryptionSecretKey = encryptionSecretKey;
        return this;
    }

    @Generated
    public BaseBinaryCipherExecutor setSigningEnabled(boolean signingEnabled) {
        this.signingEnabled = signingEnabled;
        return this;
    }

    @Generated
    protected BaseBinaryCipherExecutor() {
    }
}

