/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.webauthn.web.flow.account;

import com.yubico.core.RegistrationStorage;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.mfa.webauthn.WebAuthnMultifactorAuthenticationCoreProperties;
import org.apereo.cas.web.flow.actions.ConsumerExecutionAction;
import org.apereo.cas.web.flow.util.MultifactorAuthenticationWebflowUtils;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.webflow.execution.RequestContext;

public class WebAuthnMultifactorAccountProfilePrepareAction
extends ConsumerExecutionAction {
    public WebAuthnMultifactorAccountProfilePrepareAction(RegistrationStorage webAuthnCredentialRepository, MultifactorAuthenticationProvider webAuthnMultifactorAuthenticationProvider, CasConfigurationProperties casProperties) {
        super(requestContext -> {
            Principal principal = WebUtils.getAuthentication((RequestContext)requestContext).getPrincipal();
            WebAuthnMultifactorAuthenticationCoreProperties core = casProperties.getAuthn().getMfa().getWebAuthn().getCore();
            boolean enabled = core.isMultipleDeviceRegistrationEnabled() || webAuthnCredentialRepository.getRegistrationsByUsername(principal.getId()).isEmpty();
            requestContext.getFlowScope().put("webauthnAccountProfileRegistrationEnabled", (Object)enabled);
            MultifactorAuthenticationWebflowUtils.putMultifactorAuthenticationProvider((RequestContext)requestContext, (MultifactorAuthenticationProvider)webAuthnMultifactorAuthenticationProvider);
        });
    }
}

