/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.audit;

import java.util.HashMap;
import lombok.Generated;
import org.apereo.cas.configuration.model.core.audit.AuditEngineProperties;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.ticket.idtoken.IdTokenGenerationContext;
import org.apereo.cas.ticket.idtoken.OidcIdToken;
import org.apereo.cas.util.DigestUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.inspektr.audit.spi.support.ReturnValueAsStringResourceResolver;
import org.aspectj.lang.JoinPoint;
import org.jose4j.jwt.JwtClaims;
import org.pac4j.core.profile.UserProfile;

public class OidcIdTokenAuditResourceResolver
extends ReturnValueAsStringResourceResolver {
    private final AuditEngineProperties properties;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] resolveFrom(JoinPoint auditableTarget, Object returnValue) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        IdTokenGenerationContext idTokenContext = (IdTokenGenerationContext)auditableTarget.getArgs()[0];
        OAuth20AccessToken accessToken = idTokenContext.getAccessToken();
        if (returnValue instanceof OidcIdToken) {
            String claims;
            String token;
            OidcIdToken oidcIdToken = (OidcIdToken)returnValue;
            try {
                String string;
                token = string = oidcIdToken.token();
                claims = string = oidcIdToken.claims();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            if (claims.hasClaim("txn")) {
                String txn = (String)FunctionUtils.doUnchecked(() -> OidcIdTokenAuditResourceResolver.lambda$resolveFrom$0((JwtClaims)claims));
                FunctionUtils.doIfNotNull((Object)txn, __ -> values.put("txn", txn));
                values.put("authn_methods", accessToken.getAuthentication().getSuccesses().keySet());
            }
            values.put("id_token", DigestUtils.abbreviate((String)token, (int)this.properties.getAbbreviationLength()));
        }
        UserProfile userProfile = idTokenContext.getUserProfile();
        values.put("client_id", accessToken.getClientId());
        if (!accessToken.getScopes().isEmpty()) {
            values.put("scope", accessToken.getScopes());
        }
        FunctionUtils.doIfNotNull((Object)userProfile, __ -> values.put("username", userProfile.getId()));
        FunctionUtils.doIfNotNull((Object)accessToken.getService(), svc -> values.put("service", svc));
        return new String[]{this.auditFormat.serialize(values)};
    }

    @Generated
    public OidcIdTokenAuditResourceResolver(AuditEngineProperties properties) {
        this.properties = properties;
    }

    private static /* synthetic */ String lambda$resolveFrom$0(JwtClaims claims) throws Throwable {
        return claims.getStringClaimValue("txn");
    }
}

