/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apereo.cas.services.LogicalOperatorTypes;
import org.apereo.cas.services.RegisteredServiceAccessStrategyActivationCriteria;
import org.apereo.cas.services.RegisteredServiceAccessStrategyRequest;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.RegexUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public class AttributeBasedRegisteredServiceAccessStrategyActivationCriteria
implements RegisteredServiceAccessStrategyActivationCriteria {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AttributeBasedRegisteredServiceAccessStrategyActivationCriteria.class);
    private static final long serialVersionUID = 5228603912161923218L;
    @JsonProperty(value="requiredAttributes")
    private Map<String, Object> requiredAttributes = new TreeMap<String, Object>();
    private int order;
    private boolean allowIfInactive = true;
    private LogicalOperatorTypes operator = LogicalOperatorTypes.AND;

    public boolean shouldActivate(RegisteredServiceAccessStrategyRequest request) {
        Stream stream = this.requiredAttributes.entrySet().stream();
        return this.operator == LogicalOperatorTypes.AND ? stream.allMatch(entry -> this.verifyRequiredAttribute((Map.Entry<String, Object>)entry, request)) : stream.anyMatch(entry -> this.verifyRequiredAttribute((Map.Entry<String, Object>)entry, request));
    }

    protected boolean verifyRequiredAttribute(Map.Entry<String, Object> entry, RegisteredServiceAccessStrategyRequest request) {
        List currentValues = (List)ObjectUtils.defaultIfNull((Object)((List)request.getAttributes().get(entry.getKey())), List.of());
        Set requiredValues = CollectionUtils.toCollection((Object)entry.getValue());
        Pattern pattern = RegexUtils.concatenate((Collection)requiredValues, (boolean)true);
        LOGGER.debug("Checking activation criteria [{}] against [{}] with pattern [{}] for attribute [{}]", new Object[]{requiredValues, currentValues, pattern, entry.getKey()});
        return pattern.equals(RegexUtils.MATCH_NOTHING_PATTERN) ? currentValues.stream().anyMatch(requiredValues::contains) : currentValues.stream().map(Object::toString).anyMatch(pattern.asPredicate());
    }

    @Generated
    public Map<String, Object> getRequiredAttributes() {
        return this.requiredAttributes;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public boolean isAllowIfInactive() {
        return this.allowIfInactive;
    }

    @Generated
    public LogicalOperatorTypes getOperator() {
        return this.operator;
    }

    @JsonProperty(value="requiredAttributes")
    @Generated
    public AttributeBasedRegisteredServiceAccessStrategyActivationCriteria setRequiredAttributes(Map<String, Object> requiredAttributes) {
        this.requiredAttributes = requiredAttributes;
        return this;
    }

    @Generated
    public AttributeBasedRegisteredServiceAccessStrategyActivationCriteria setOrder(int order) {
        this.order = order;
        return this;
    }

    @Generated
    public AttributeBasedRegisteredServiceAccessStrategyActivationCriteria setAllowIfInactive(boolean allowIfInactive) {
        this.allowIfInactive = allowIfInactive;
        return this;
    }

    @Generated
    public AttributeBasedRegisteredServiceAccessStrategyActivationCriteria setOperator(LogicalOperatorTypes operator) {
        this.operator = operator;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AttributeBasedRegisteredServiceAccessStrategyActivationCriteria)) {
            return false;
        }
        AttributeBasedRegisteredServiceAccessStrategyActivationCriteria other = (AttributeBasedRegisteredServiceAccessStrategyActivationCriteria)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.order != other.order) {
            return false;
        }
        if (this.allowIfInactive != other.allowIfInactive) {
            return false;
        }
        Map<String, Object> this$requiredAttributes = this.requiredAttributes;
        Map<String, Object> other$requiredAttributes = other.requiredAttributes;
        if (this$requiredAttributes == null ? other$requiredAttributes != null : !((Object)this$requiredAttributes).equals(other$requiredAttributes)) {
            return false;
        }
        LogicalOperatorTypes this$operator = this.operator;
        LogicalOperatorTypes other$operator = other.operator;
        return !(this$operator == null ? other$operator != null : !this$operator.equals(other$operator));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AttributeBasedRegisteredServiceAccessStrategyActivationCriteria;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.order;
        result = result * 59 + (this.allowIfInactive ? 79 : 97);
        Map<String, Object> $requiredAttributes = this.requiredAttributes;
        result = result * 59 + ($requiredAttributes == null ? 43 : ((Object)$requiredAttributes).hashCode());
        LogicalOperatorTypes $operator = this.operator;
        result = result * 59 + ($operator == null ? 43 : $operator.hashCode());
        return result;
    }

    @Generated
    public AttributeBasedRegisteredServiceAccessStrategyActivationCriteria() {
    }
}

