/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api.remote;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.event.ConnectorEvent;
import org.identityconnectors.common.event.ConnectorEventHandler;
import org.identityconnectors.common.event.ConnectorEventPublisher;
import org.identityconnectors.common.l10n.CurrentLocale;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.api.ConnectorInfo;
import org.identityconnectors.framework.api.ConnectorInfoManager;
import org.identityconnectors.framework.api.ConnectorKey;
import org.identityconnectors.framework.api.RemoteFrameworkConnectionInfo;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.exceptions.ConnectorIOException;
import org.identityconnectors.framework.common.serializer.SerializerUtil;
import org.identityconnectors.framework.impl.api.remote.RemoteConnectorInfoImpl;
import org.identityconnectors.framework.impl.api.remote.RemoteFrameworkConnection;
import org.identityconnectors.framework.impl.api.remote.messages.ErrorResponse;
import org.identityconnectors.framework.impl.api.remote.messages.HelloRequest;
import org.identityconnectors.framework.impl.api.remote.messages.HelloResponse;

public class RemoteConnectorInfoManagerImpl
implements ConnectorInfoManager,
ConnectorEventPublisher,
Runnable {
    private static final Log LOG = Log.getLog(RemoteConnectorInfoManagerImpl.class);
    private final RemoteFrameworkConnectionInfo frameworkConnectionInfo;
    private List<ConnectorInfo> connectorInfoList;
    private Long serverStartTime = null;
    private final List<ConnectorEventHandler> eventHandlers = new ArrayList<ConnectorEventHandler>();

    private RemoteConnectorInfoManagerImpl() {
        this.frameworkConnectionInfo = null;
    }

    public RemoteConnectorInfoManagerImpl(RemoteFrameworkConnectionInfo info) throws RuntimeException {
        this(info, true);
    }

    public RemoteConnectorInfoManagerImpl(RemoteFrameworkConnectionInfo info, boolean loadConnectorInfo) {
        this.frameworkConnectionInfo = info;
        if (loadConnectorInfo) {
            this.init();
        } else {
            this.connectorInfoList = null;
        }
    }

    private void init() {
        HelloResponse response = null;
        try (RemoteFrameworkConnection connection = new RemoteFrameworkConnection(this.frameworkConnectionInfo);){
            connection.writeObject(CurrentLocale.get());
            connection.writeObject(this.frameworkConnectionInfo.getKey());
            connection.writeObject(new HelloRequest(20));
            response = this.fetchHelloResponse(connection);
        }
        if (null == response) {
            LOG.error("HelloResponse is null from {0}", new Object[]{this.frameworkConnectionInfo});
            throw new ConnectorIOException("HelloResponse is null from " + this.frameworkConnectionInfo.toString());
        }
        if (response.getException() != null) {
            throw ConnectorException.wrap((Throwable)response.getException());
        }
        List<RemoteConnectorInfoImpl> remoteInfos = response.getConnectorInfos();
        remoteInfos.forEach(remoteInfo -> remoteInfo.setRemoteConnectionInfo(this.frameworkConnectionInfo));
        List<ConnectorInfo> connectorInfoBefore = this.connectorInfoList;
        this.connectorInfoList = CollectionUtil.newReadOnlyList(remoteInfos);
        Object o = response.getServerInfo().get("SERVER_START_TIME");
        this.serverStartTime = o instanceof Long ? (Long)o : Long.valueOf(System.currentTimeMillis());
        ArrayList<ConnectorInfo> unchanged = new ArrayList<ConnectorInfo>(this.connectorInfoList.size());
        if (null != connectorInfoBefore) {
            for (ConnectorInfo oldCi : connectorInfoBefore) {
                boolean unregistered = true;
                for (ConnectorInfo newCi2 : this.connectorInfoList) {
                    if (!oldCi.getConnectorKey().equals((Object)newCi2.getConnectorKey())) continue;
                    unregistered = false;
                    unchanged.add(newCi2);
                    break;
                }
                if (!unregistered) continue;
                this.notifyListeners(new ConnectorEvent("CONNID_CONNECTOREVENT-UNREGISTERING", oldCi.getConnectorKey()));
            }
        }
        this.connectorInfoList.stream().filter(newCi -> !unchanged.contains(newCi)).forEachOrdered(newCi -> this.notifyListeners(new ConnectorEvent("CONNID_CONNECTOREVENT-REGISTERED", newCi.getConnectorKey())));
    }

    private HelloResponse fetchHelloResponse(RemoteFrameworkConnection connection) throws Throwable {
        Object response = connection.readObject();
        if (response instanceof HelloResponse) {
            return (HelloResponse)response;
        }
        if (response instanceof ErrorResponse) {
            ErrorResponse error = (ErrorResponse)response;
            if (error.getException() != null) {
                throw error.getException();
            }
            throw new ConnectorException("Received an invalid Error response object, exception parameter missing");
        }
        throw new ConnectorException("Received unknown response object type: " + response.getClass().getCanonicalName());
    }

    public RemoteConnectorInfoManagerImpl derive(RemoteFrameworkConnectionInfo info) {
        RemoteConnectorInfoManagerImpl rv = new RemoteConnectorInfoManagerImpl();
        if (null == this.connectorInfoList || this.connectorInfoList.isEmpty()) {
            rv.connectorInfoList = Collections.emptyList();
        } else {
            List remoteInfos = (List)SerializerUtil.cloneObject(this.connectorInfoList);
            remoteInfos.forEach(remoteInfo -> remoteInfo.setRemoteConnectionInfo(info));
            rv.connectorInfoList = CollectionUtil.newReadOnlyList((List)remoteInfos);
        }
        return rv;
    }

    public ConnectorInfo findConnectorInfo(ConnectorKey key) {
        for (ConnectorInfo info : this.getConnectorInfos()) {
            if (!info.getConnectorKey().equals((Object)key)) continue;
            return info;
        }
        return null;
    }

    public List<ConnectorInfo> getConnectorInfos() {
        List<Object> result = this.connectorInfoList;
        if (null == result) {
            result = Collections.emptyList();
        }
        return result;
    }

    @Override
    public void run() {
        try {
            Map<String, Object> serverInfo = this.getServerInfo();
            Object o = serverInfo.get("SERVER_START_TIME");
            if (o instanceof Long && (null == this.serverStartTime || (Long)o > this.serverStartTime)) {
                if (LOG.isOk()) {
                    if (null != this.serverStartTime) {
                        LOG.ok("Connector server has been restarted since {0}, new start time: {1}", new Object[]{new Date(this.serverStartTime), new Date((Long)o)});
                    } else {
                        LOG.ok("First connection to connector server has been established, new start time: {0}", new Object[]{new Date((Long)o)});
                    }
                }
                this.init();
            }
        }
        catch (ConnectorIOException e) {
            if (null != this.connectorInfoList) {
                this.connectorInfoList.forEach(connectorInfo -> this.notifyListeners(new ConnectorEvent("CONNID_CONNECTOREVENT-UNREGISTERING", connectorInfo.getConnectorKey())));
            }
            this.connectorInfoList = null;
            LOG.error("Failed to connect to remote connector server {0}", new Object[]{this.frameworkConnectionInfo});
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "Failed to update the ConnectorInfo from remote connector server", new Object[0]);
        }
    }

    public void addConnectorEventHandler(ConnectorEventHandler hook) {
        if (hook == null) {
            throw new NullPointerException();
        }
        if (!this.eventHandlers.contains(hook)) {
            if (null != this.connectorInfoList) {
                this.connectorInfoList.forEach(connectorInfo -> hook.handleEvent(new ConnectorEvent("CONNID_CONNECTOREVENT-REGISTERED", connectorInfo.getConnectorKey())));
            }
            this.eventHandlers.add(hook);
        }
    }

    public void deleteConnectorEventHandler(ConnectorEventHandler hook) {
        this.eventHandlers.remove(hook);
    }

    public Map<String, Object> getServerInfo() throws RuntimeException {
        try (RemoteFrameworkConnection connection = new RemoteFrameworkConnection(this.frameworkConnectionInfo);){
            connection.writeObject(CurrentLocale.get());
            connection.writeObject(this.frameworkConnectionInfo.getKey());
            connection.writeObject(new HelloRequest(4));
            HelloResponse response = (HelloResponse)connection.readObject();
            if (response.getException() instanceof ConnectorException) {
                throw (ConnectorException)response.getException();
            }
            if (response.getException() != null) {
                throw ConnectorException.wrap((Throwable)response.getException());
            }
            Map<String, Object> map = response.getServerInfo();
            return map;
        }
    }

    public List<ConnectorKey> getConnectorKeys() throws RuntimeException {
        try (RemoteFrameworkConnection connection = new RemoteFrameworkConnection(this.frameworkConnectionInfo);){
            connection.writeObject(CurrentLocale.get());
            connection.writeObject(this.frameworkConnectionInfo.getKey());
            connection.writeObject(new HelloRequest(16));
            HelloResponse response = (HelloResponse)connection.readObject();
            if (response.getException() instanceof ConnectorException) {
                throw (ConnectorException)response.getException();
            }
            if (response.getException() != null) {
                throw ConnectorException.wrap((Throwable)response.getException());
            }
            List<ConnectorKey> list = response.getConnectorKeys();
            return list;
        }
    }

    private void notifyListeners(ConnectorEvent event) {
        Object[] arrLocal = this.eventHandlers.toArray();
        for (int i = arrLocal.length - 1; i >= 0; --i) {
            try {
                ((ConnectorEventHandler)arrLocal[i]).handleEvent(new ConnectorEvent(event));
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

