/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity;

import com.fasterxml.jackson.core.type.TypeReference;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.PostLoad;
import jakarta.persistence.PostPersist;
import jakarta.persistence.PostUpdate;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.persistence.UniqueConstraint;
import jakarta.validation.Valid;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.syncope.core.persistence.api.entity.DynRealm;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.Role;
import org.apache.syncope.core.persistence.jpa.entity.AbstractProvidedKeyEntity;
import org.apache.syncope.core.persistence.jpa.entity.JPADynRealm;
import org.apache.syncope.core.persistence.jpa.entity.JPARealm;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;

@Entity
@Table(name="SyncopeRole")
@Cacheable
public class JPARole
extends AbstractProvidedKeyEntity
implements Role,
PersistenceCapable {
    private static final long serialVersionUID = -7657701119422588832L;
    public static final String TABLE = "SyncopeRole";
    protected static final TypeReference<Set<String>> TYPEREF = new TypeReference<Set<String>>(){};
    @Lob
    private String entitlements;
    @Transient
    private Set<String> entitlementsSet = new HashSet<String>();
    private String dynMembershipCond;
    @Lob
    private String anyLayout;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(joinColumns={@JoinColumn(name="role_id")}, inverseJoinColumns={@JoinColumn(name="realm_id")}, uniqueConstraints={@UniqueConstraint(columnNames={"role_id", "realm_id"})})
    @Valid
    private List<JPARealm> realms = new ArrayList<JPARealm>();
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(joinColumns={@JoinColumn(name="role_id")}, inverseJoinColumns={@JoinColumn(name="dynamicRealm_id")}, uniqueConstraints={@UniqueConstraint(columnNames={"role_id", "dynamicRealm_id"})})
    @Valid
    private List<JPADynRealm> dynRealms = new ArrayList<JPADynRealm>();
    private static int pcInheritedFieldCount = AbstractProvidedKeyEntity.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;

    public Set<String> getEntitlements() {
        return this.entitlementsSet;
    }

    public String getDynMembershipCond() {
        return JPARole.pcGetdynMembershipCond(this);
    }

    public void setDynMembershipCond(String dynMembershipCond) {
        JPARole.pcSetdynMembershipCond(this, dynMembershipCond);
    }

    public boolean add(Realm realm) {
        this.checkType(realm, JPARealm.class);
        return JPARole.pcGetrealms(this).contains((JPARealm)realm) || JPARole.pcGetrealms(this).add((JPARealm)realm);
    }

    public List<? extends Realm> getRealms() {
        return JPARole.pcGetrealms(this);
    }

    public boolean add(DynRealm dynamicRealm) {
        this.checkType(dynamicRealm, JPADynRealm.class);
        return JPARole.pcGetdynRealms(this).contains((JPADynRealm)dynamicRealm) || JPARole.pcGetdynRealms(this).add((JPADynRealm)dynamicRealm);
    }

    public List<? extends DynRealm> getDynRealms() {
        return JPARole.pcGetdynRealms(this);
    }

    public String getAnyLayout() {
        return JPARole.pcGetanyLayout(this);
    }

    public void setAnyLayout(String anyLayout) {
        JPARole.pcSetanyLayout(this, anyLayout);
    }

    protected void json2list(boolean clearFirst) {
        if (clearFirst) {
            this.getEntitlements().clear();
        }
        if (JPARole.pcGetentitlements(this) != null) {
            this.getEntitlements().addAll((Collection)POJOHelper.deserialize((String)JPARole.pcGetentitlements(this), TYPEREF));
        }
    }

    @PostLoad
    public void postLoad() {
        this.json2list(false);
    }

    @PostPersist
    @PostUpdate
    public void postSave() {
        this.json2list(true);
    }

    @PrePersist
    @PreUpdate
    public void list2json() {
        JPARole.pcSetentitlements(this, POJOHelper.serialize(this.getEntitlements()));
    }

    static {
        pcPCSuperclass = AbstractProvidedKeyEntity.class;
        pcFieldNames = new String[]{"anyLayout", "dynMembershipCond", "dynRealms", "entitlements", "realms"};
        pcFieldTypes = new Class[]{String.class, String.class, List.class, String.class, List.class};
        pcFieldFlags = new byte[]{26, 26, 10, 26, 10};
        PCRegistry.register(JPARole.class, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"JPARole", (PersistenceCapable)new JPARole());
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 255933283;
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.anyLayout = null;
        this.dynMembershipCond = null;
        this.dynRealms = null;
        this.entitlements = null;
        this.realms = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JPARole jPARole = new JPARole();
        if (bl) {
            jPARole.pcClearFields();
        }
        jPARole.pcStateManager = stateManager;
        jPARole.pcCopyKeyFieldsFromObjectId(object);
        return jPARole;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JPARole jPARole = new JPARole();
        if (bl) {
            jPARole.pcClearFields();
        }
        jPARole.pcStateManager = stateManager;
        return jPARole;
    }

    protected static int pcGetManagedFieldCount() {
        return 5 + AbstractProvidedKeyEntity.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.anyLayout = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.dynMembershipCond = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.dynRealms = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.entitlements = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.realms = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcReplaceField(nArray[i]);
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.anyLayout);
                return;
            }
            case 1: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.dynMembershipCond);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.dynRealms);
                return;
            }
            case 3: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.entitlements);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.realms);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcProvideField(nArray[i]);
        }
    }

    protected void pcCopyField(JPARole jPARole, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(jPARole, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.anyLayout = jPARole.anyLayout;
                return;
            }
            case 1: {
                this.dynMembershipCond = jPARole.dynMembershipCond;
                return;
            }
            case 2: {
                this.dynRealms = jPARole.dynRealms;
                return;
            }
            case 3: {
                this.entitlements = jPARole.entitlements;
                return;
            }
            case 4: {
                this.realms = jPARole.realms;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        JPARole jPARole = (JPARole)object;
        if (jPARole.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.pcCopyField(jPARole, nArray[i]);
        }
    }

    @Override
    public Class pcGetIDOwningClass() {
        return JPARole.class;
    }

    private static final String pcGetanyLayout(JPARole jPARole) {
        if (jPARole.pcStateManager == null) {
            return jPARole.anyLayout;
        }
        int n = pcInheritedFieldCount + 0;
        jPARole.pcStateManager.accessingField(n);
        return jPARole.anyLayout;
    }

    private static final void pcSetanyLayout(JPARole jPARole, String string) {
        if (jPARole.pcStateManager == null) {
            jPARole.anyLayout = string;
            return;
        }
        jPARole.pcStateManager.settingStringField((PersistenceCapable)jPARole, pcInheritedFieldCount + 0, jPARole.anyLayout, string, 0);
    }

    private static final String pcGetdynMembershipCond(JPARole jPARole) {
        if (jPARole.pcStateManager == null) {
            return jPARole.dynMembershipCond;
        }
        int n = pcInheritedFieldCount + 1;
        jPARole.pcStateManager.accessingField(n);
        return jPARole.dynMembershipCond;
    }

    private static final void pcSetdynMembershipCond(JPARole jPARole, String string) {
        if (jPARole.pcStateManager == null) {
            jPARole.dynMembershipCond = string;
            return;
        }
        jPARole.pcStateManager.settingStringField((PersistenceCapable)jPARole, pcInheritedFieldCount + 1, jPARole.dynMembershipCond, string, 0);
    }

    private static final List pcGetdynRealms(JPARole jPARole) {
        if (jPARole.pcStateManager == null) {
            return jPARole.dynRealms;
        }
        int n = pcInheritedFieldCount + 2;
        jPARole.pcStateManager.accessingField(n);
        return jPARole.dynRealms;
    }

    private static final void pcSetdynRealms(JPARole jPARole, List list) {
        if (jPARole.pcStateManager == null) {
            jPARole.dynRealms = list;
            return;
        }
        jPARole.pcStateManager.settingObjectField((PersistenceCapable)jPARole, pcInheritedFieldCount + 2, jPARole.dynRealms, (Object)list, 0);
    }

    private static final String pcGetentitlements(JPARole jPARole) {
        if (jPARole.pcStateManager == null) {
            return jPARole.entitlements;
        }
        int n = pcInheritedFieldCount + 3;
        jPARole.pcStateManager.accessingField(n);
        return jPARole.entitlements;
    }

    private static final void pcSetentitlements(JPARole jPARole, String string) {
        if (jPARole.pcStateManager == null) {
            jPARole.entitlements = string;
            return;
        }
        jPARole.pcStateManager.settingStringField((PersistenceCapable)jPARole, pcInheritedFieldCount + 3, jPARole.entitlements, string, 0);
    }

    private static final List pcGetrealms(JPARole jPARole) {
        if (jPARole.pcStateManager == null) {
            return jPARole.realms;
        }
        int n = pcInheritedFieldCount + 4;
        jPARole.pcStateManager.accessingField(n);
        return jPARole.realms;
    }

    private static final void pcSetrealms(JPARole jPARole, List list) {
        if (jPARole.pcStateManager == null) {
            jPARole.realms = list;
            return;
        }
        jPARole.pcStateManager.settingObjectField((PersistenceCapable)jPARole, pcInheritedFieldCount + 4, jPARole.realms, (Object)list, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

