/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import org.acplt.oncrpc.OncRpcAuthenticationException;
import org.acplt.oncrpc.OncRpcClientAuth;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.OncRpcReplyMessage;
import org.acplt.oncrpc.XdrDecodingStream;

public class OncRpcClientReplyMessage
extends OncRpcReplyMessage {
    protected OncRpcClientAuth auth;

    public OncRpcClientReplyMessage(OncRpcClientAuth auth) {
        this.auth = auth;
    }

    public boolean successfullyAccepted() {
        return this.replyStatus == 0 && this.acceptStatus == 0;
    }

    public OncRpcException newException() {
        switch (this.replyStatus) {
            case 0: {
                switch (this.acceptStatus) {
                    case 0: {
                        return new OncRpcException(0);
                    }
                    case 3: {
                        return new OncRpcException(10);
                    }
                    case 2: {
                        return new OncRpcException(9);
                    }
                    case 1: {
                        return new OncRpcException(8);
                    }
                    case 4: {
                        return new OncRpcException(11);
                    }
                    case 5: {
                        return new OncRpcException(12);
                    }
                }
                break;
            }
            case 1: {
                switch (this.rejectStatus) {
                    case 1: {
                        return new OncRpcAuthenticationException(this.authStatus);
                    }
                    case 0: {
                        return new OncRpcException(16);
                    }
                }
            }
        }
        return new OncRpcException();
    }

    public void xdrDecode(XdrDecodingStream xdr) throws OncRpcException, IOException {
        this.messageId = xdr.xdrDecodeInt();
        this.messageType = xdr.xdrDecodeInt();
        if (this.messageType != 1) {
            throw new OncRpcException(44);
        }
        this.replyStatus = xdr.xdrDecodeInt();
        block0 : switch (this.replyStatus) {
            case 0: {
                if (this.auth != null) {
                    this.auth.xdrDecodeVerf(xdr);
                } else {
                    if (xdr.xdrDecodeInt() != 0) {
                        throw new OncRpcAuthenticationException(7);
                    }
                    if (xdr.xdrDecodeInt() != 0) {
                        throw new OncRpcAuthenticationException(7);
                    }
                }
                this.acceptStatus = xdr.xdrDecodeInt();
                switch (this.acceptStatus) {
                    case 2: {
                        this.lowVersion = xdr.xdrDecodeInt();
                        this.highVersion = xdr.xdrDecodeInt();
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                this.rejectStatus = xdr.xdrDecodeInt();
                switch (this.rejectStatus) {
                    case 0: {
                        this.lowVersion = xdr.xdrDecodeInt();
                        this.highVersion = xdr.xdrDecodeInt();
                        break block0;
                    }
                    case 1: {
                        this.authStatus = xdr.xdrDecodeInt();
                        break block0;
                    }
                }
            }
        }
    }
}

