/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.groovy.sandbox.impl;

import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.codehaus.groovy.reflection.ParameterTypes;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.kohsuke.groovy.sandbox.impl.Checker;

public class GroovyCallSiteSelector {
    private static final Class<?>[] SYNTHETIC_CONSTRUCTOR_PARAMETER_TYPES = new Class[]{Checker.SuperConstructorWrapper.class, Checker.ThisConstructorWrapper.class};

    private GroovyCallSiteSelector() {
    }

    public static Constructor<?> findConstructor(Class<?> type, Object[] args) {
        Constructor<?> c = GroovyCallSiteSelector.constructor(type, args);
        if (c == null) {
            throw new SecurityException("Unable to find constructor: " + GroovyCallSiteSelector.formatConstructor(type, args));
        }
        if (GroovyCallSiteSelector.isIllegalCallToSyntheticConstructor(c, args)) {
            String alternateConstructors = Stream.of(c.getDeclaringClass().getDeclaredConstructors()).filter(tempC -> !GroovyCallSiteSelector.isSyntheticConstructor(tempC)).map(Object::toString).sorted().collect(Collectors.joining(", "));
            throw new SecurityException("Rejecting illegal call to synthetic constructor: " + c + ". Perhaps you meant to use one of these constructors instead: " + alternateConstructors);
        }
        return c;
    }

    static Constructor<?> constructor(Class<?> receiver, Object[] args) {
        Constructor<?>[] constructors = receiver.getDeclaredConstructors();
        Constructor<?> bestMatch = null;
        ParameterTypes bestMatchParamTypes = null;
        Class[] argTypes = MetaClassHelper.convertToTypeArray((Object[])args);
        for (Constructor<?> c : constructors) {
            ParameterTypes cParamTypes = new ParameterTypes((Class[])c.getParameterTypes());
            if (!cParamTypes.isValidMethod(argTypes) || bestMatch != null && !GroovyCallSiteSelector.isMoreSpecific(cParamTypes, bestMatchParamTypes, argTypes)) continue;
            bestMatch = c;
            bestMatchParamTypes = cParamTypes;
        }
        if (bestMatch != null) {
            return bestMatch;
        }
        if (args.length == 1 && args[0] instanceof Map) {
            for (Constructor<?> c : constructors) {
                if (c.getParameterTypes().length != 0 || c.isVarArgs()) continue;
                return c;
            }
        }
        return null;
    }

    public static boolean isMoreSpecific(ParameterTypes paramsForCandidate, ParameterTypes paramsForBaseline, Class<?>[] argTypes) {
        long currentBestDistance;
        long candidateDistance = MetaClassHelper.calculateParameterDistance((Class[])argTypes, (ParameterTypes)paramsForCandidate);
        return candidateDistance < (currentBestDistance = MetaClassHelper.calculateParameterDistance((Class[])argTypes, (ParameterTypes)paramsForBaseline));
    }

    private static boolean isSyntheticConstructor(Constructor<?> c) {
        for (Class<?> parameterType : c.getParameterTypes()) {
            for (Class<?> syntheticParamType : SYNTHETIC_CONSTRUCTOR_PARAMETER_TYPES) {
                if (parameterType != syntheticParamType) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isIllegalCallToSyntheticConstructor(Constructor<?> c, Object[] args) {
        Class<?>[] parameterTypes = c.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            Object arg = args[i];
            for (Class<?> syntheticParamType : SYNTHETIC_CONSTRUCTOR_PARAMETER_TYPES) {
                if (parameterType != syntheticParamType || arg != null && arg.getClass() == syntheticParamType) continue;
                return true;
            }
        }
        return false;
    }

    public static String formatConstructor(Class<?> c, Object ... args) {
        return "new " + GroovyCallSiteSelector.getName(c) + GroovyCallSiteSelector.printArgumentTypes(args);
    }

    private static String printArgumentTypes(Object[] args) {
        StringBuilder b = new StringBuilder();
        for (Object arg : args) {
            b.append(' ');
            b.append(GroovyCallSiteSelector.getName(arg));
        }
        return b.toString();
    }

    public static String getName(Object o) {
        return o == null ? "null" : GroovyCallSiteSelector.getName(o.getClass());
    }

    private static String getName(Class<?> c) {
        Class<?> e = c.getComponentType();
        if (e == null) {
            return c.getName();
        }
        return GroovyCallSiteSelector.getName(e) + "[]";
    }
}

