/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.protocol;

import java.io.DataOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.kafka.common.protocol.DataOutputStreamWritable;
import org.apache.kafka.common.utils.ByteBufferOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DataOutputStreamWritableTest {
    @Test
    public void testWritingSlicedByteBuffer() {
        byte[] expectedArray = new byte[]{2, 3, 0, 0};
        ByteBuffer sourceBuffer = ByteBuffer.wrap(new byte[]{0, 1, 2, 3});
        ByteBuffer resultBuffer = ByteBuffer.allocate(4);
        sourceBuffer.position(2);
        ByteBuffer slicedBuffer = sourceBuffer.slice();
        DataOutputStreamWritable writable = new DataOutputStreamWritable(new DataOutputStream((OutputStream)new ByteBufferOutputStream(resultBuffer)));
        writable.writeByteBuffer(slicedBuffer);
        Assertions.assertEquals((int)2, (int)resultBuffer.position(), (String)"Writing to the buffer moves the position forward");
        Assertions.assertArrayEquals((byte[])expectedArray, (byte[])resultBuffer.array(), (String)"Result buffer should have expected elements");
    }

    @Test
    public void testWritingSlicedByteBufferWithNonZeroPosition() {
        byte[] expectedArray = new byte[]{3, 0, 0, 0};
        ByteBuffer originalBuffer = ByteBuffer.wrap(new byte[]{0, 1, 2, 3});
        ByteBuffer resultBuffer = ByteBuffer.allocate(4);
        originalBuffer.position(2);
        ByteBuffer slicedBuffer = originalBuffer.slice();
        slicedBuffer.position(1);
        DataOutputStreamWritable writable = new DataOutputStreamWritable(new DataOutputStream((OutputStream)new ByteBufferOutputStream(resultBuffer)));
        writable.writeByteBuffer(slicedBuffer);
        Assertions.assertEquals((int)1, (int)resultBuffer.position(), (String)"Writing to the buffer moves the position forward");
        Assertions.assertArrayEquals((byte[])expectedArray, (byte[])resultBuffer.array(), (String)"Result buffer should have expected elements");
    }
}

