/*
 * Decompiled with CFR 0.152.
 */
package retrofit2.converter.moshi;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonWriter;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.ByteString;
import retrofit2.Converter;
import retrofit2.converter.moshi.MoshiStreamingRequestBody;

final class MoshiRequestBodyConverter<T>
implements Converter<T, RequestBody> {
    static final MediaType MEDIA_TYPE = MediaType.get((String)"application/json; charset=UTF-8");
    private final JsonAdapter<T> adapter;
    private final boolean streaming;

    MoshiRequestBodyConverter(JsonAdapter<T> adapter, boolean streaming) {
        this.adapter = adapter;
        this.streaming = streaming;
    }

    public RequestBody convert(T value) throws IOException {
        if (this.streaming) {
            return new MoshiStreamingRequestBody<T>(this.adapter, value);
        }
        Buffer buffer = new Buffer();
        JsonWriter writer = JsonWriter.of((BufferedSink)buffer);
        this.adapter.toJson(writer, value);
        return RequestBody.create((MediaType)MEDIA_TYPE, (ByteString)buffer.readByteString());
    }
}

