/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.security;

import com.nimbusds.jwt.JWTClaimsSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.syncope.core.spring.security.SyncopeAuthenticationDetails;
import org.apache.syncope.core.spring.security.SyncopeGrantedAuthority;
import org.springframework.security.core.Authentication;

public class JWTAuthentication
implements Authentication {
    private static final long serialVersionUID = -2013733709281305394L;
    private final JWTClaimsSet claims;
    private final SyncopeAuthenticationDetails details;
    private String username;
    private final Set<SyncopeGrantedAuthority> authorities = new HashSet<SyncopeGrantedAuthority>();
    private boolean authenticated = false;

    public JWTAuthentication(JWTClaimsSet claims, SyncopeAuthenticationDetails details) {
        this.claims = claims;
        this.details = details;
    }

    public JWTClaimsSet getClaims() {
        return this.claims;
    }

    public Collection<SyncopeGrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public Object getCredentials() {
        return "";
    }

    public SyncopeAuthenticationDetails getDetails() {
        return this.details;
    }

    public Object getPrincipal() {
        return Optional.ofNullable(this.username).orElseGet(() -> ((JWTClaimsSet)this.claims).getSubject());
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public void setAuthenticated(boolean authenticated) throws IllegalArgumentException {
        this.authenticated = authenticated;
    }

    public String getName() {
        return Optional.ofNullable(this.username).orElseGet(() -> ((JWTClaimsSet)this.claims).getSubject());
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.claims).append((Object)this.details).append((Object)this.username).append(this.authorities).append(this.authenticated).build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JWTAuthentication other = (JWTAuthentication)obj;
        return new EqualsBuilder().append((Object)this.claims, (Object)other.claims).append((Object)this.details, (Object)other.details).append((Object)this.username, (Object)other.username).append(this.authorities, other.authorities).append(this.authenticated, other.authenticated).build();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString()).append(": ");
        sb.append("Principal: ").append(this.getPrincipal()).append("; ");
        sb.append("Authenticated: ").append(this.isAuthenticated()).append("; ");
        sb.append("Details: ").append(this.getDetails()).append("; ");
        if (!this.authorities.isEmpty()) {
            sb.append("Granted Authorities: ");
            sb.append(this.authorities.stream().map(SyncopeGrantedAuthority::toString).collect(Collectors.joining(", ")));
        } else {
            sb.append("Not granted any authorities");
        }
        return sb.toString();
    }
}

