/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.ssl;

import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import org.ldaptive.ssl.DefaultHostnameVerifier;
import org.ldaptive.ssl.X509ExtendedTrustManagerWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregateTrustManager
extends X509ExtendedTrustManager {
    private static final int DEFAULT_CHAIN_LOG_DEPTH = 3;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final X509ExtendedTrustManager[] trustManagers;
    private final Strategy trustStrategy;

    public AggregateTrustManager(X509TrustManager ... managers) {
        this(Strategy.ALL, managers);
    }

    public AggregateTrustManager(Strategy strategy, X509TrustManager ... managers) {
        Objects.requireNonNull(strategy, "Strategy cannot be null");
        this.trustStrategy = strategy;
        if (managers == null || managers.length == 0) {
            throw new IllegalArgumentException("Trust managers cannot be empty or null");
        }
        for (X509TrustManager tm2 : managers) {
            if (tm2.getAcceptedIssuers() != null) continue;
            throw new IllegalArgumentException("Trust manager " + String.valueOf(tm2) + " cannot return null accepted issuers");
        }
        this.trustManagers = (X509ExtendedTrustManager[])Stream.of(managers).map(tm -> {
            if (tm instanceof X509ExtendedTrustManager) {
                return (X509ExtendedTrustManager)tm;
            }
            return new X509ExtendedTrustManagerWrapper((X509TrustManager)tm, new DefaultHostnameVerifier());
        }).toArray(X509ExtendedTrustManager[]::new);
    }

    public X509TrustManager[] getTrustManagers() {
        return this.trustManagers;
    }

    public Strategy getTrustStrategy() {
        return this.trustStrategy;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        try {
            this.trustManagerCheck(tm -> tm.checkClientTrusted(chain, authType, socket));
        }
        catch (CertificateException e) {
            throw new CertificateException(this.createCertificateExceptionMessage(chain), e);
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        try {
            this.trustManagerCheck(tm -> tm.checkClientTrusted(chain, authType, engine));
        }
        catch (CertificateException e) {
            throw new CertificateException(this.createCertificateExceptionMessage(chain), e);
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        try {
            this.trustManagerCheck(tm -> tm.checkClientTrusted(chain, authType));
        }
        catch (CertificateException e) {
            throw new CertificateException(this.createCertificateExceptionMessage(chain), e);
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        try {
            this.trustManagerCheck(tm -> tm.checkServerTrusted(chain, authType, socket));
        }
        catch (CertificateException e) {
            throw new CertificateException(this.createCertificateExceptionMessage(chain), e);
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        try {
            this.trustManagerCheck(tm -> tm.checkServerTrusted(chain, authType, engine));
        }
        catch (CertificateException e) {
            throw new CertificateException(this.createCertificateExceptionMessage(chain), e);
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        try {
            this.trustManagerCheck(tm -> tm.checkServerTrusted(chain, authType));
        }
        catch (CertificateException e) {
            throw new CertificateException(this.createCertificateExceptionMessage(chain), e);
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        ArrayList issuers = new ArrayList();
        for (X509ExtendedTrustManager tm : this.trustManagers) {
            Collections.addAll(issuers, tm.getAcceptedIssuers());
        }
        return issuers.toArray(new X509Certificate[0]);
    }

    public String toString() {
        return "[" + this.getClass().getName() + "@" + this.hashCode() + "::trustManagers=" + Arrays.toString(this.trustManagers) + ", trustStrategy=" + String.valueOf((Object)this.trustStrategy) + "]";
    }

    protected String createCertificateExceptionMessage(X509Certificate[] chain) {
        X509Certificate[] issuers = this.getAcceptedIssuers();
        if (chain == null) {
            return "Trust check failed with null chain";
        }
        if (issuers == null) {
            return "Trust check failed with null trust anchors";
        }
        return "Trust check failed for chain [" + this.certsToString(chain, true) + "] using trust anchors [" + this.certsToString(issuers, false) + "]";
    }

    private String certsToString(X509Certificate[] chain, boolean withIssuer) {
        String s = IntStream.range(0, Math.min(chain.length, 3)).mapToObj(i -> i + "=" + this.certToString(chain[i], withIssuer)).collect(Collectors.joining(", "));
        return chain.length > 3 ? s + ", ..." : s;
    }

    private String certToString(X509Certificate cert, boolean withIssuer) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault(Locale.Category.FORMAT));
        StringBuilder sb = new StringBuilder("{s:");
        if (cert.getSubjectX500Principal() != null) {
            sb.append(cert.getSubjectX500Principal().getName());
        } else {
            sb.append("null");
        }
        sb.append(", ");
        if (withIssuer) {
            sb.append("i:");
            if (cert.getIssuerX500Principal() != null) {
                sb.append(cert.getIssuerX500Principal().getName());
            } else {
                sb.append("null");
            }
            sb.append(", ");
        }
        sb.append("e:");
        if (cert.getNotAfter() != null) {
            sb.append(df.format(cert.getNotAfter()));
        } else {
            sb.append("null");
        }
        sb.append("}");
        return sb.toString();
    }

    private void trustManagerCheck(TrustManagerConsumer consumer) throws CertificateException {
        CertificateException certEx = null;
        for (X509ExtendedTrustManager tm : this.trustManagers) {
            try {
                consumer.checkTrusted(tm);
                this.logger.trace("checkServerTrusted for {} succeeded", (Object)tm);
                if (this.trustStrategy != Strategy.ANY) continue;
                return;
            }
            catch (CertificateException e) {
                this.logger.trace("checkServerTrusted for {} failed", (Object)tm);
                if (this.trustStrategy == Strategy.ALL) {
                    throw e;
                }
                if (certEx != null) continue;
                certEx = e;
            }
        }
        if (certEx != null) {
            throw certEx;
        }
    }

    private static interface TrustManagerConsumer {
        public void checkTrusted(X509ExtendedTrustManager var1) throws CertificateException;
    }

    public static enum Strategy {
        ALL,
        ANY;

    }
}

