/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.transport;

import java.lang.reflect.Constructor;
import org.ldaptive.LdapUtils;
import org.ldaptive.transport.DelegateTransportFactory;
import org.ldaptive.transport.ThreadPoolConfig;
import org.ldaptive.transport.Transport;
import org.ldaptive.transport.netty.NettyTransportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransportFactory {
    private static final String TRANSPORT_FACTORY_PROPERTY = "org.ldaptive.transport.factory";
    private static final Logger LOGGER = LoggerFactory.getLogger(TransportFactory.class);
    private static final DelegateTransportFactory TRANSPORT_FACTORY;

    private TransportFactory() {
    }

    public static Transport getTransport(ThreadPoolConfig config) {
        return TRANSPORT_FACTORY.createTransport(config);
    }

    static {
        Constructor transportFactory = LdapUtils.createConstructorFromProperty(TRANSPORT_FACTORY_PROPERTY);
        if (transportFactory != null) {
            try {
                TRANSPORT_FACTORY = (DelegateTransportFactory)transportFactory.newInstance(new Object[0]);
                LOGGER.info("Transport factory override set to {}", (Object)TRANSPORT_FACTORY);
            }
            catch (Exception e) {
                LOGGER.error("Error creating new transport factory instance with {}", transportFactory, (Object)e);
                throw new IllegalStateException(e);
            }
        } else {
            TRANSPORT_FACTORY = new NettyTransportFactory();
        }
    }
}

