/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl;

import java.time.Duration;
import java.util.TimeZone;
import org.springframework.integration.dsl.PollerSpec;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.scheduling.support.PeriodicTrigger;

public final class Pollers {
    public static PollerSpec fixedRate(long period) {
        return Pollers.fixedRate(Duration.ofMillis(period));
    }

    public static PollerSpec fixedRate(Duration period) {
        return Pollers.periodicTrigger(period, true, null);
    }

    public static PollerSpec fixedRate(Duration period, Duration initialDelay) {
        return Pollers.periodicTrigger(period, true, initialDelay);
    }

    public static PollerSpec fixedRate(long period, long initialDelay) {
        return Pollers.fixedRate(Duration.ofMillis(period), Duration.ofMillis(initialDelay));
    }

    public static PollerSpec fixedDelay(Duration period) {
        return Pollers.periodicTrigger(period, false, null);
    }

    public static PollerSpec fixedDelay(long period) {
        return Pollers.fixedDelay(Duration.ofMillis(period));
    }

    public static PollerSpec fixedDelay(Duration period, Duration initialDelay) {
        return Pollers.periodicTrigger(period, false, initialDelay);
    }

    public static PollerSpec fixedDelay(long period, long initialDelay) {
        return Pollers.fixedDelay(Duration.ofMillis(period), Duration.ofMillis(initialDelay));
    }

    private static PollerSpec periodicTrigger(Duration period, boolean fixedRate, @Nullable Duration initialDelay) {
        PeriodicTrigger periodicTrigger = new PeriodicTrigger(period);
        periodicTrigger.setFixedRate(fixedRate);
        if (initialDelay != null) {
            periodicTrigger.setInitialDelay(initialDelay);
        }
        return Pollers.trigger((Trigger)periodicTrigger);
    }

    public static PollerSpec cron(String cronExpression) {
        return Pollers.cron(cronExpression, TimeZone.getDefault());
    }

    public static PollerSpec cron(String cronExpression, TimeZone timeZone) {
        return Pollers.trigger((Trigger)new CronTrigger(cronExpression, timeZone));
    }

    public static PollerSpec trigger(Trigger trigger2) {
        return new PollerSpec(trigger2);
    }

    private Pollers() {
    }
}

