/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.store;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.store.AbstractBatchingMessageGroupStore;
import org.springframework.integration.store.MessageGroup;
import org.springframework.integration.store.MessageGroupFactory;
import org.springframework.integration.store.MessageGroupMetadata;
import org.springframework.integration.store.MessageGroupStore;
import org.springframework.integration.store.SimpleMessageGroupFactory;
import org.springframework.integration.store.UniqueExpiryCallback;
import org.springframework.integration.support.locks.DefaultLockRegistry;
import org.springframework.integration.support.locks.LockRegistry;
import org.springframework.integration.util.CheckedCallable;
import org.springframework.integration.util.CheckedRunnable;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

@ManagedResource
public abstract class AbstractMessageGroupStore
extends AbstractBatchingMessageGroupStore
implements MessageGroupStore,
Iterable<MessageGroup> {
    protected static final String INTERRUPTED_WHILE_OBTAINING_LOCK = "Interrupted while obtaining lock";
    protected static final String GROUP_ID_MUST_NOT_BE_NULL = "'groupId' must not be null";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Lock lock = new ReentrantLock();
    private final Collection<MessageGroupStore.MessageGroupCallback> expiryCallbacks = new LinkedHashSet<MessageGroupStore.MessageGroupCallback>();
    private final MessageGroupFactory persistentMessageGroupFactory = new SimpleMessageGroupFactory(SimpleMessageGroupFactory.GroupType.PERSISTENT);
    private boolean lazyLoadMessageGroups = true;
    private boolean timeoutOnIdle;
    private LockRegistry lockRegistry = new DefaultLockRegistry();

    protected AbstractMessageGroupStore() {
    }

    protected AbstractMessageGroupStore(boolean lazyLoadMessageGroups) {
        this.lazyLoadMessageGroups = lazyLoadMessageGroups;
    }

    @Override
    protected MessageGroupFactory getMessageGroupFactory() {
        if (this.lazyLoadMessageGroups) {
            return this.persistentMessageGroupFactory;
        }
        return super.getMessageGroupFactory();
    }

    public void setExpiryCallbacks(Collection<MessageGroupStore.MessageGroupCallback> expiryCallbacks) {
        expiryCallbacks.forEach(this::registerMessageGroupExpiryCallback);
    }

    public boolean isTimeoutOnIdle() {
        return this.timeoutOnIdle;
    }

    public void setTimeoutOnIdle(boolean timeoutOnIdle) {
        this.timeoutOnIdle = timeoutOnIdle;
    }

    public void setLazyLoadMessageGroups(boolean lazyLoadMessageGroups) {
        this.lazyLoadMessageGroups = lazyLoadMessageGroups;
    }

    public final void setLockRegistry(LockRegistry lockRegistry) {
        Assert.notNull((Object)lockRegistry, (String)"The LockRegistry cannot be null");
        this.lockRegistry = lockRegistry;
    }

    protected LockRegistry getLockRegistry() {
        return this.lockRegistry;
    }

    @Override
    public void registerMessageGroupExpiryCallback(MessageGroupStore.MessageGroupCallback callback) {
        if (callback instanceof UniqueExpiryCallback) {
            boolean uniqueExpiryCallbackPresent = this.expiryCallbacks.stream().anyMatch(UniqueExpiryCallback.class::isInstance);
            if (uniqueExpiryCallbackPresent) {
                this.logger.error((Object)"Only one instance of 'UniqueExpiryCallback' can be registered in the 'MessageGroupStore'. Use a separate 'MessageGroupStore' for each aggregator/resequencer.");
            }
        }
        this.expiryCallbacks.add(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManagedOperation
    public int expireMessageGroups(long timeout) {
        this.lock.lock();
        try {
            int count = 0;
            long threshold = System.currentTimeMillis() - timeout;
            for (MessageGroup group : this) {
                long timestamp = group.getTimestamp();
                if (this.isTimeoutOnIdle() && group.getLastModified() > 0L) {
                    timestamp = group.getLastModified();
                }
                if (timestamp > threshold) continue;
                ++count;
                this.expire(this.copy(group));
            }
            int n = count;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected MessageGroup copy(MessageGroup group) {
        return group;
    }

    @Override
    @ManagedAttribute
    public int getMessageCountForAllMessageGroups() {
        int count = 0;
        for (MessageGroup group : this) {
            count += group.size();
        }
        return count;
    }

    @Override
    @ManagedAttribute
    public int getMessageGroupCount() {
        int count = 0;
        for (MessageGroup group : this) {
            ++count;
        }
        return count;
    }

    @Override
    public MessageGroupMetadata getGroupMetadata(Object groupId) {
        throw new UnsupportedOperationException("Not yet implemented for this store");
    }

    @Override
    public void removeMessagesFromGroup(Object key, Message<?> ... messages) {
        this.removeMessagesFromGroup(key, Arrays.asList(messages));
    }

    @Override
    public void removeMessagesFromGroup(Object key, Collection<Message<?>> messages) {
        Assert.notNull((Object)key, (String)GROUP_ID_MUST_NOT_BE_NULL);
        this.executeLocked(key, () -> this.doRemoveMessagesFromGroup(key, messages));
    }

    protected abstract void doRemoveMessagesFromGroup(Object var1, Collection<Message<?>> var2);

    @Override
    public void addMessagesToGroup(Object groupId, Message<?> ... messages) {
        Assert.notNull((Object)groupId, (String)GROUP_ID_MUST_NOT_BE_NULL);
        this.executeLocked(groupId, () -> this.doAddMessagesToGroup(groupId, messages));
    }

    protected abstract void doAddMessagesToGroup(Object var1, Message<?> ... var2);

    @Override
    public MessageGroup addMessageToGroup(Object groupId, Message<?> message) {
        this.addMessagesToGroup(groupId, message);
        return this.getMessageGroup(groupId);
    }

    @Override
    public void removeMessageGroup(Object groupId) {
        Assert.notNull((Object)groupId, (String)GROUP_ID_MUST_NOT_BE_NULL);
        this.executeLocked(groupId, () -> this.doRemoveMessageGroup(groupId));
    }

    protected abstract void doRemoveMessageGroup(Object var1);

    @Override
    public boolean removeMessageFromGroupById(Object groupId, UUID messageId) {
        Assert.notNull((Object)groupId, (String)GROUP_ID_MUST_NOT_BE_NULL);
        return this.executeLocked(groupId, () -> this.doRemoveMessageFromGroupById(groupId, messageId));
    }

    protected boolean doRemoveMessageFromGroupById(Object groupId, UUID messageId) {
        throw new UnsupportedOperationException("Not supported for this store");
    }

    @Override
    public void setLastReleasedSequenceNumberForGroup(Object groupId, int sequenceNumber) {
        Assert.notNull((Object)groupId, (String)GROUP_ID_MUST_NOT_BE_NULL);
        this.executeLocked(groupId, () -> this.doSetLastReleasedSequenceNumberForGroup(groupId, sequenceNumber));
    }

    protected abstract void doSetLastReleasedSequenceNumberForGroup(Object var1, int var2);

    @Override
    public void completeGroup(Object groupId) {
        Assert.notNull((Object)groupId, (String)GROUP_ID_MUST_NOT_BE_NULL);
        this.executeLocked(groupId, () -> this.doCompleteGroup(groupId));
    }

    protected abstract void doCompleteGroup(Object var1);

    @Override
    public void setGroupCondition(Object groupId, String condition) {
        Assert.notNull((Object)groupId, (String)GROUP_ID_MUST_NOT_BE_NULL);
        this.executeLocked(groupId, () -> this.doSetGroupCondition(groupId, condition));
    }

    protected abstract void doSetGroupCondition(Object var1, String var2);

    @Override
    public Message<?> pollMessageFromGroup(Object groupId) {
        Assert.notNull((Object)groupId, (String)GROUP_ID_MUST_NOT_BE_NULL);
        return this.executeLocked(groupId, () -> this.doPollMessageFromGroup(groupId));
    }

    protected abstract Message<?> doPollMessageFromGroup(Object var1);

    protected <T, E extends RuntimeException> T executeLocked(Object groupId, CheckedCallable<T, E> runnable) {
        try {
            return this.lockRegistry.executeLocked(groupId, runnable);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(INTERRUPTED_WHILE_OBTAINING_LOCK, ex);
        }
    }

    protected <E extends RuntimeException> void executeLocked(Object groupId, CheckedRunnable<E> runnable) {
        try {
            this.lockRegistry.executeLocked(groupId, runnable);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(INTERRUPTED_WHILE_OBTAINING_LOCK, ex);
        }
    }

    private void expire(MessageGroup group) {
        RuntimeException exception = null;
        for (MessageGroupStore.MessageGroupCallback callback : this.expiryCallbacks) {
            try {
                callback.execute(this, group);
            }
            catch (RuntimeException e) {
                if (exception == null) {
                    exception = e;
                }
                this.logger.error((Object)"Exception in expiry callback", (Throwable)e);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }
}

