/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.query;

import java.io.StringWriter;
import java.util.Objects;
import lombok.Generated;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.UniqueTicketIdGenerator;
import org.apereo.cas.ticket.query.SamlAttributeQueryTicket;
import org.apereo.cas.ticket.query.SamlAttributeQueryTicketFactory;
import org.apereo.cas.ticket.query.SamlAttributeQueryTicketImpl;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.common.SAMLObject;

public class DefaultSamlAttributeQueryTicketFactory
implements SamlAttributeQueryTicketFactory {
    protected final ExpirationPolicyBuilder expirationPolicyBuilder;
    protected final ServiceFactory<WebApplicationService> webApplicationServiceFactory;
    protected final OpenSamlConfigBean configBean;
    protected final UniqueTicketIdGenerator ticketIdGenerator = UniqueTicketIdGenerator.prefixedTicketIdGenerator();

    @Override
    public SamlAttributeQueryTicket create(String id, SAMLObject samlObject, String relyingParty, TicketGrantingTicket ticketGrantingTicket) {
        return (SamlAttributeQueryTicket)FunctionUtils.doUnchecked(() -> {
            try (StringWriter transformSamlObject = SamlUtils.transformSamlObject((OpenSamlConfigBean)this.configBean, (XMLObject)samlObject);){
                String codeId = this.createTicketIdFor(id, relyingParty);
                WebApplicationService service = (WebApplicationService)this.webApplicationServiceFactory.createService(relyingParty);
                service.getAttributes().put(TicketGrantingTicket.class.getSimpleName(), CollectionUtils.wrapList((Object[])new String[]{ticketGrantingTicket.getId()}));
                service.getAttributes().put(RegisteredService.class.getSimpleName(), CollectionUtils.wrapList((Object[])new String[]{relyingParty}));
                service.getAttributes().put("owner", CollectionUtils.wrapList((Object[])new String[]{this.getTicketType().getName()}));
                SamlAttributeQueryTicketImpl samlAttributeQueryTicketImpl = new SamlAttributeQueryTicketImpl(codeId, (Service)service, this.expirationPolicyBuilder.buildTicketExpirationPolicy(), relyingParty, transformSamlObject.toString(), Objects.requireNonNull(ticketGrantingTicket).getAuthentication());
                return samlAttributeQueryTicketImpl;
            }
        });
    }

    public Class<? extends Ticket> getTicketType() {
        return SamlAttributeQueryTicket.class;
    }

    @Generated
    public DefaultSamlAttributeQueryTicketFactory(ExpirationPolicyBuilder expirationPolicyBuilder, ServiceFactory<WebApplicationService> webApplicationServiceFactory, OpenSamlConfigBean configBean) {
        this.expirationPolicyBuilder = expirationPolicyBuilder;
        this.webApplicationServiceFactory = webApplicationServiceFactory;
        this.configBean = configBean;
    }

    @Generated
    public ExpirationPolicyBuilder getExpirationPolicyBuilder() {
        return this.expirationPolicyBuilder;
    }

    @Generated
    public UniqueTicketIdGenerator getTicketIdGenerator() {
        return this.ticketIdGenerator;
    }
}

