/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.DataObject;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.engine.impl.bpmn.parser.BpmnParse;
import org.flowable.engine.parse.BpmnParseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BpmnParseHandlers {
    private static final Logger LOGGER = LoggerFactory.getLogger(BpmnParseHandlers.class);
    protected Map<Class<? extends BaseElement>, List<BpmnParseHandler>> parseHandlers = new HashMap<Class<? extends BaseElement>, List<BpmnParseHandler>>();

    public List<BpmnParseHandler> getHandlersFor(Class<? extends BaseElement> clazz) {
        return this.parseHandlers.get(clazz);
    }

    public void addHandlers(List<BpmnParseHandler> bpmnParseHandlers) {
        for (BpmnParseHandler bpmnParseHandler : bpmnParseHandlers) {
            this.addHandler(bpmnParseHandler);
        }
    }

    public void addHandler(BpmnParseHandler bpmnParseHandler) {
        for (Class<? extends BaseElement> type : bpmnParseHandler.getHandledTypes()) {
            List<BpmnParseHandler> handlers = this.parseHandlers.get(type);
            if (handlers == null) {
                handlers = new ArrayList<BpmnParseHandler>();
                this.parseHandlers.put(type, handlers);
            }
            handlers.add(bpmnParseHandler);
        }
    }

    public void parseElement(BpmnParse bpmnParse, BaseElement element) {
        List<BpmnParseHandler> handlers;
        if (element instanceof DataObject) {
            return;
        }
        if (element instanceof FlowElement) {
            bpmnParse.setCurrentFlowElement((FlowElement)element);
        }
        if ((handlers = this.parseHandlers.get(element.getClass())) == null) {
            LOGGER.warn("Could not find matching parse handler for + {} this is likely a bug.", (Object)element.getId());
        } else {
            for (BpmnParseHandler handler : handlers) {
                handler.parse(bpmnParse, element);
            }
        }
    }
}

