/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import org.flowable.batch.api.Batch;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.migration.ProcessInstanceMigrationDocument;
import org.flowable.engine.migration.ProcessInstanceMigrationManager;

public class ProcessInstanceMigrationBatchCmd
implements Command<Batch> {
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected int processDefinitionVersion;
    protected String processDefinitionTenantId;
    protected ProcessInstanceMigrationDocument processInstanceMigrationDocument;

    public ProcessInstanceMigrationBatchCmd(String processDefinitionId, ProcessInstanceMigrationDocument processInstanceMigrationDocument) {
        if (processDefinitionId == null) {
            throw new FlowableException("Must specify a process definition id to migrate");
        }
        if (processInstanceMigrationDocument == null) {
            throw new FlowableException("Must specify a process migration document to migrate");
        }
        this.processDefinitionId = processDefinitionId;
        this.processInstanceMigrationDocument = processInstanceMigrationDocument;
    }

    public ProcessInstanceMigrationBatchCmd(String processDefinitionKey, int processDefinitionVersion, String processDefinitionTenantId, ProcessInstanceMigrationDocument processInstanceMigrationDocument) {
        if (processDefinitionKey == null) {
            throw new FlowableException("Must specify a process definition key to migrate");
        }
        if (processInstanceMigrationDocument == null) {
            throw new FlowableException("Must specify a process migration document to migrate");
        }
        this.processDefinitionKey = processDefinitionKey;
        this.processDefinitionVersion = processDefinitionVersion;
        this.processDefinitionTenantId = processDefinitionTenantId;
        this.processInstanceMigrationDocument = processInstanceMigrationDocument;
    }

    public Batch execute(CommandContext commandContext) {
        ProcessInstanceMigrationManager migrationManager = CommandContextUtil.getProcessEngineConfiguration(commandContext).getProcessInstanceMigrationManager();
        if (this.processDefinitionId != null) {
            return migrationManager.batchMigrateProcessInstancesOfProcessDefinition(this.processDefinitionId, this.processInstanceMigrationDocument, commandContext);
        }
        return migrationManager.batchMigrateProcessInstancesOfProcessDefinition(this.processDefinitionKey, this.processDefinitionVersion, this.processDefinitionTenantId, this.processInstanceMigrationDocument, commandContext);
    }
}

