/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.duo.authn;

import com.duosecurity.client.Http;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.net.ssl.X509TrustManager;
import lombok.Generated;
import okhttp3.OkHttpClient;
import org.apache.commons.lang3.Strings;
import org.apereo.cas.adaptors.duo.DuoSecurityBypassCode;
import org.apereo.cas.adaptors.duo.DuoSecurityUserAccount;
import org.apereo.cas.adaptors.duo.DuoSecurityUserAccountGroup;
import org.apereo.cas.adaptors.duo.DuoSecurityUserAccountStatus;
import org.apereo.cas.adaptors.duo.DuoSecurityUserDevice;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityAdminApiService;
import org.apereo.cas.configuration.model.support.mfa.duo.DuoSecurityMultifactorAuthenticationProperties;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.http.HttpClient;
import org.apereo.cas.util.http.HttpClientFactory;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.http.HttpMethod;
import org.springframework.util.ReflectionUtils;

public class DefaultDuoSecurityAdminApiService
implements DuoSecurityAdminApiService {
    private static final long TIMEOUT_SECONDS = 60L;
    private final HttpClient httpClient;
    private final DuoSecurityMultifactorAuthenticationProperties duoProperties;

    private static String getAdminEndpointUri(String uri) {
        return "/admin/v1/" + uri;
    }

    public Optional<DuoSecurityUserAccount> getDuoSecurityUserAccount(String username, boolean fetchBypassCodes) throws Exception {
        JSONArray userResponse = (JSONArray)this.executeAdminEndpoint(CollectionUtils.wrap((String)"uri", (Object)"users", (String)"username", (Object)username));
        if (userResponse != null && userResponse.length() == 1) {
            JSONObject userJson = userResponse.getJSONObject(0);
            DuoSecurityUserAccount user = this.mapDuoSecurityUserAccount(userJson);
            if (fetchBypassCodes) {
                user.addBypassCodes(this.getDuoSecurityBypassCodesFor(user.getUserId()));
            }
            return Optional.of(user);
        }
        return Optional.empty();
    }

    public Optional<DuoSecurityUserAccount> modifyDuoSecurityUserAccount(DuoSecurityUserAccount newAccount) throws Exception {
        JSONArray userResponse = (JSONArray)this.executeAdminEndpoint(CollectionUtils.wrap((String)"uri", (Object)"users", (String)"username", (Object)newAccount.getUsername()));
        if (userResponse != null && userResponse.length() == 1) {
            Object object;
            DuoSecurityUserAccount user = this.mapDuoSecurityUserAccount(userResponse.getJSONObject(0));
            Map parameters = CollectionUtils.wrap((String)"method", (Object)HttpMethod.POST.name(), (String)"uri", (Object)"users/%s".formatted(user.getUserId()));
            FunctionUtils.doIfNotNull((Object)newAccount.getEmail(), __ -> parameters.put("email", newAccount.getEmail()));
            FunctionUtils.doIfNotNull((Object)newAccount.getFirstName(), __ -> parameters.put("firstname", newAccount.getFirstName()));
            FunctionUtils.doIfNotNull((Object)newAccount.getLastName(), __ -> parameters.put("lastname", newAccount.getLastName()));
            FunctionUtils.doIfNotNull((Object)newAccount.getStatus(), __ -> parameters.put("status", newAccount.getStatus().toValue()));
            Object updateResponse = this.executeAdminEndpoint(parameters);
            if (updateResponse instanceof JSONArray) {
                JSONArray array = (JSONArray)updateResponse;
                object = array.get(0);
            } else {
                object = updateResponse;
            }
            JSONObject userAccount = (JSONObject)object;
            return Optional.of(this.mapDuoSecurityUserAccount(userAccount));
        }
        return Optional.empty();
    }

    public void deleteDuoSecurityUserDevice(String username, String deviceId) throws Exception {
        String userIdentifier = this.getDuoSecurityUserAccount(username, false).map(DuoSecurityUserAccount::getUserId).orElseThrow();
        Map params = CollectionUtils.wrap((String)"uri", (Object)String.format("users/%s/phones/%s", userIdentifier, deviceId));
        params.put("method", HttpMethod.DELETE.name());
        this.executeAdminEndpoint(params);
    }

    public List<Long> createDuoSecurityBypassCodesFor(String userIdentifier) throws Exception {
        Map params = CollectionUtils.wrap((String)"uri", (Object)String.format("users/%s/bypass_codes", userIdentifier));
        params.put("method", HttpMethod.POST.name());
        JSONArray bypassResponse = (JSONArray)this.executeAdminEndpoint(params);
        if (bypassResponse != null) {
            return Arrays.stream(bypassResponse.join(",").replace("\"", "").split(",")).map(Long::valueOf).collect(Collectors.toList());
        }
        return new ArrayList<Long>();
    }

    public List<DuoSecurityBypassCode> getDuoSecurityBypassCodesFor(String userIdentifier) throws Exception {
        ArrayList<DuoSecurityBypassCode> codes = new ArrayList<DuoSecurityBypassCode>();
        JSONArray bypassResponse = (JSONArray)this.executeAdminEndpoint(CollectionUtils.wrap((String)"uri", (Object)String.format("users/%s/bypass_codes", userIdentifier)));
        for (int i = 0; bypassResponse != null && i < bypassResponse.length(); ++i) {
            JSONObject bypassJson = bypassResponse.getJSONObject(i);
            if (!bypassJson.has("bypass_code_id")) continue;
            DuoSecurityBypassCode code = new DuoSecurityBypassCode(bypassJson.getString("bypass_code_id"));
            code.setCreated(bypassJson.optLong("created"));
            code.setExpiration(bypassJson.optLong("expiration"));
            code.setReuseCount(bypassJson.optLong("reuse_count"));
            code.setCreatedBy(bypassJson.optString("admin_email"));
            codes.add(code);
        }
        return codes;
    }

    protected void prepareHttpRequest(Http request) {
    }

    private Object executeAdminEndpoint(Map<String, String> params) throws Exception {
        SpringExpressionLanguageValueResolver resolver = SpringExpressionLanguageValueResolver.getInstance();
        String uri = DefaultDuoSecurityAdminApiService.getAdminEndpointUri(params.getOrDefault("uri", ""));
        String method = params.getOrDefault("method", HttpMethod.GET.name());
        String originalHost = resolver.resolve(this.duoProperties.getDuoApiHost());
        URI host = new URI(Strings.CI.prependIfMissing(originalHost, (CharSequence)"https://", new CharSequence[0]));
        Http request = new CasHttpBuilder(method, host.getHost(), uri).build();
        Field hostField = ReflectionUtils.findField(request.getClass(), (String)"host");
        ReflectionUtils.makeAccessible((Field)Objects.requireNonNull(hostField));
        String resultingHost = host.getHost() + (String)(host.getPort() > 0 ? ":" + host.getPort() : "");
        ReflectionUtils.setField((Field)hostField, (Object)request, (Object)resultingHost);
        HttpClientFactory factory = this.httpClient.httpClientFactory();
        OkHttpClient okHttpClient = new OkHttpClient.Builder().connectTimeout(60L, TimeUnit.SECONDS).writeTimeout(60L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).sslSocketFactory(factory.getSslContext().getSocketFactory(), (X509TrustManager)factory.getTrustManagers()[0]).hostnameVerifier(factory.getHostnameVerifier()).build();
        request.addParam("offset", "0");
        request.addParam("limit", params.getOrDefault("limit", "1"));
        params.forEach((arg_0, arg_1) -> ((Http)request).addParam(arg_0, arg_1));
        String ikey = resolver.resolve(this.duoProperties.getDuoAdminIntegrationKey());
        String skey = resolver.resolve(this.duoProperties.getDuoAdminSecretKey());
        request.signRequest(ikey, skey);
        Optional.ofNullable(factory.getProxy()).ifPresent(proxy -> request.setProxy(proxy.getHostName(), proxy.getPort()));
        Field httpClientField = ReflectionUtils.findField(request.getClass(), (String)"httpClient");
        ReflectionUtils.makeAccessible((Field)Objects.requireNonNull(httpClientField));
        ReflectionUtils.setField((Field)httpClientField, (Object)request, (Object)okHttpClient);
        this.prepareHttpRequest(request);
        JSONObject result = (JSONObject)request.executeJSONRequest();
        if (!result.isEmpty() && result.has("response") && result.has("stat")) {
            JSONArray response = result.optJSONArray("response");
            if (response == null) {
                return result.optJSONObject("response", result);
            }
            return response;
        }
        return null;
    }

    protected DuoSecurityUserAccount mapDuoSecurityUserAccount(JSONObject userJson) throws JSONException {
        DuoSecurityUserAccount user = new DuoSecurityUserAccount(userJson.getString("username"));
        user.setUserId(userJson.getString("user_id"));
        user.setStatus(DuoSecurityUserAccountStatus.from((String)userJson.getString("status")));
        DefaultDuoSecurityAdminApiService.collectDuoSecurityUserAccountAttribute(userJson, "email", user);
        DefaultDuoSecurityAdminApiService.collectDuoSecurityUserAccountAttribute(userJson, "user_id", user);
        DefaultDuoSecurityAdminApiService.collectDuoSecurityUserAccountAttribute(userJson, "firstname", user);
        DefaultDuoSecurityAdminApiService.collectDuoSecurityUserAccountAttribute(userJson, "lastname", user);
        DefaultDuoSecurityAdminApiService.collectDuoSecurityUserAccountAttribute(userJson, "realname", user);
        DefaultDuoSecurityAdminApiService.collectDuoSecurityUserAccountAttribute(userJson, "is_enrolled", user);
        DefaultDuoSecurityAdminApiService.collectDuoSecurityUserAccountAttribute(userJson, "last_login", user);
        DefaultDuoSecurityAdminApiService.collectDuoSecurityUserAccountAttribute(userJson, "created", user);
        DefaultDuoSecurityAdminApiService.collectDuoSecurityUserAccountAttribute(userJson, "alias1", user);
        DefaultDuoSecurityAdminApiService.collectDuoSecurityUserAccountAttribute(userJson, "alias2", user);
        DefaultDuoSecurityAdminApiService.collectDuoSecurityUserAccountAttribute(userJson, "notes", user);
        DefaultDuoSecurityAdminApiService.collectDuoSecurityUserAccountAttribute(userJson, "lockout_reason", user);
        if (user.getStatus() != DuoSecurityUserAccountStatus.DENY && !user.isEnrolled()) {
            user.setStatus(DuoSecurityUserAccountStatus.ENROLL);
        }
        user.setProviderId(this.duoProperties.getId());
        DefaultDuoSecurityAdminApiService.mapUserPhones(userJson, user);
        DefaultDuoSecurityAdminApiService.mapUserGroups(userJson, user);
        return user;
    }

    private static void collectDuoSecurityUserAccountAttribute(JSONObject userJson, String attribute, DuoSecurityUserAccount user) {
        FunctionUtils.doIfNotNull((Object)userJson.opt(attribute), value -> user.addAttribute(attribute, value.toString()));
    }

    private static void mapUserGroups(JSONObject userJson, DuoSecurityUserAccount user) throws JSONException {
        JSONArray groupsResponse = userJson.getJSONArray("groups");
        for (int i = 0; groupsResponse != null && i < groupsResponse.length(); ++i) {
            JSONObject json = groupsResponse.getJSONObject(i);
            if (!json.has("group_id")) continue;
            DuoSecurityUserAccountGroup group = new DuoSecurityUserAccountGroup(json.getString("group_id"), json.getString("name"), json.getString("status"));
            group.setDescription(json.optString("description"));
            group.setMobileOtpEnabled(json.optBoolean("mobile_otp_enabled"));
            group.setPushEnabled(json.optBoolean("push_enabled"));
            group.setSmsEnabled(json.optBoolean("sms_enabled"));
            group.setVoiceEnabled(json.optBoolean("voice_enabled"));
            user.addGroup(group);
        }
    }

    private static void mapUserPhones(JSONObject userJson, DuoSecurityUserAccount user) throws JSONException {
        JSONArray phones = userJson.getJSONArray("phones");
        for (int i = 0; phones != null && i < phones.length(); ++i) {
            JSONObject phoneJson = phones.getJSONObject(i);
            DuoSecurityUserDevice phone = new DuoSecurityUserDevice(phoneJson.getString("name"), phoneJson.getString("type"));
            phone.setActivated(phoneJson.optBoolean("activated"));
            phone.setLastSeen(phoneJson.optString("last_seen"));
            phone.setModel(phoneJson.optString("model"));
            phone.setNumber(phoneJson.optString("number"));
            phone.setPlatform(phoneJson.optString("platform"));
            phone.setId(phoneJson.optString("phone_id"));
            phone.setCapabilities(List.of(phoneJson.getJSONArray("capabilities").join(",").replace("\"", "").split(",")));
            user.addDevice(phone);
        }
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultDuoSecurityAdminApiService)) {
            return false;
        }
        DefaultDuoSecurityAdminApiService other = (DefaultDuoSecurityAdminApiService)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HttpClient this$httpClient = this.httpClient;
        HttpClient other$httpClient = other.httpClient;
        if (this$httpClient == null ? other$httpClient != null : !this$httpClient.equals(other$httpClient)) {
            return false;
        }
        DuoSecurityMultifactorAuthenticationProperties this$duoProperties = this.duoProperties;
        DuoSecurityMultifactorAuthenticationProperties other$duoProperties = other.duoProperties;
        return !(this$duoProperties == null ? other$duoProperties != null : !this$duoProperties.equals(other$duoProperties));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DefaultDuoSecurityAdminApiService;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HttpClient $httpClient = this.httpClient;
        result = result * 59 + ($httpClient == null ? 43 : $httpClient.hashCode());
        DuoSecurityMultifactorAuthenticationProperties $duoProperties = this.duoProperties;
        result = result * 59 + ($duoProperties == null ? 43 : $duoProperties.hashCode());
        return result;
    }

    @Generated
    public DefaultDuoSecurityAdminApiService(HttpClient httpClient, DuoSecurityMultifactorAuthenticationProperties duoProperties) {
        this.httpClient = httpClient;
        this.duoProperties = duoProperties;
    }

    private static final class CasHttpBuilder
    extends Http.HttpBuilder {
        CasHttpBuilder(String method, String host, String uri) {
            super(method, host, uri);
        }
    }
}

