/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.duo.web.flow.action;

import com.duosecurity.Client;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityAuthenticationService;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityClient;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityMultifactorAuthenticationProvider;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationResultBuilder;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.MultifactorAuthenticationUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.pac4j.BrowserWebStorageSessionStore;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.TransientSessionTicket;
import org.apereo.cas.ticket.TransientSessionTicketFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.BrowserStorage;
import org.apereo.cas.web.flow.actions.AbstractMultifactorAuthenticationAction;
import org.apereo.cas.web.flow.util.MultifactorAuthenticationWebflowUtils;
import org.apereo.cas.web.support.WebUtils;
import org.pac4j.core.context.WebContext;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.scope.ConversationScope;
import org.springframework.webflow.scope.FlashScope;
import org.springframework.webflow.scope.FlowScope;
import org.springframework.webflow.scope.RequestScope;

public class DuoSecurityUniversalPromptPrepareLoginAction
extends AbstractMultifactorAuthenticationAction<DuoSecurityMultifactorAuthenticationProvider> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DuoSecurityUniversalPromptPrepareLoginAction.class);
    protected final BrowserWebStorageSessionStore duoUniversalPromptSessionStore;
    protected final TicketRegistry ticketRegistry;
    protected final TicketFactory ticketFactory;
    protected final TenantExtractor tenantExtractor;

    protected Event doExecuteInternal(RequestContext requestContext) throws Exception {
        ApplicationContext applicationContext = requestContext.getActiveFlow().getApplicationContext();
        Authentication authentication = WebUtils.getAuthentication((RequestContext)requestContext);
        String duoSecurityIdentifier = MultifactorAuthenticationWebflowUtils.getMultifactorAuthenticationProvider((RequestContext)requestContext);
        DuoSecurityMultifactorAuthenticationProvider duoProvider = MultifactorAuthenticationUtils.getMultifactorAuthenticationProviderById((String)duoSecurityIdentifier, (ApplicationContext)applicationContext).map(DuoSecurityMultifactorAuthenticationProvider.class::cast).orElseThrow(() -> new IllegalArgumentException("Unable to locate multifactor authentication provider by id " + duoSecurityIdentifier));
        Client client = this.getDuoSecurityClient(requestContext, duoProvider, duoSecurityIdentifier).getInstance();
        String state = client.generateState();
        WebApplicationService service = WebUtils.getService((RequestContext)requestContext);
        LOGGER.debug("Generated Duo Security state [{}] for service [{}]", (Object)state, (Object)service);
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        properties.put("duoProviderId", duoSecurityIdentifier);
        properties.put(Authentication.class.getSimpleName(), authentication);
        properties.put("authentication", authentication);
        AuthenticationResultBuilder authenticationResultBuilder = WebUtils.getAuthenticationResultBuilder((RequestContext)requestContext);
        properties.put(AuthenticationResultBuilder.class.getSimpleName(), authenticationResultBuilder);
        properties.put("authenticationResultBuilder", authenticationResultBuilder);
        AuthenticationResult authenticationResult = WebUtils.getAuthenticationResult((RequestContext)requestContext);
        properties.put(AuthenticationResult.class.getSimpleName(), authenticationResult);
        properties.put("authenticationResult", authenticationResult);
        properties.put(Credential.class.getSimpleName(), MultifactorAuthenticationWebflowUtils.getMultifactorAuthenticationParentCredential((RequestContext)requestContext));
        FunctionUtils.doIfNotNull((Object)service, __ -> properties.put(Service.class.getSimpleName(), service));
        properties.put(DuoSecurityAuthenticationService.class.getSimpleName(), state);
        String targetState = WebUtils.getTargetTransition((RequestContext)requestContext);
        FunctionUtils.doIfNotNull((Object)targetState, __ -> properties.put("targetTransitionToActivate", targetState));
        properties.put(FlowScope.class.getSimpleName(), requestContext.getFlowScope().asMap());
        properties.put(FlashScope.class.getSimpleName(), requestContext.getFlashScope().asMap());
        properties.put(ConversationScope.class.getSimpleName(), requestContext.getConversationScope().asMap());
        properties.put(RequestScope.class.getSimpleName(), requestContext.getRequestScope().asMap());
        Optional.ofNullable(WebUtils.getRegisteredService((RequestContext)requestContext)).ifPresent(registeredService -> properties.put(RegisteredService.class.getSimpleName(), registeredService));
        Pair<String, String> urlWithStatePair = this.createAuthUrlWithState(duoProvider, properties, requestContext, state);
        requestContext.getFlowScope().put("duoUniversalPromptLoginUrl", urlWithStatePair.getLeft());
        if (!((DuoSecurityMultifactorAuthenticationProvider)this.provider).getDuoAuthenticationService().getProperties().getSessionStorageType().isTicketRegistry()) {
            HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
            HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext);
            JEEContext context = new JEEContext(request, response);
            LOGGER.debug("Storing Duo Security session attributes [{}] into session", properties);
            BrowserStorage sessionStorage = this.duoUniversalPromptSessionStore.withSessionAttributes((WebContext)context, properties).getTrackableSession((WebContext)context).map(BrowserStorage.class::cast).orElseThrow(() -> new IllegalStateException("Unable to determine trackable session for storage"));
            sessionStorage.setDestinationUrl((String)urlWithStatePair.getLeft());
            WebUtils.putBrowserStorage((RequestContext)requestContext, (BrowserStorage)sessionStorage);
            return this.success(sessionStorage);
        }
        LOGGER.debug("Redirecting to Duo Security url at [{}]", urlWithStatePair);
        return this.success(urlWithStatePair.getRight());
    }

    protected DuoSecurityClient getDuoSecurityClient(RequestContext requestContext, DuoSecurityMultifactorAuthenticationProvider duoProvider, String duoSecurityIdentifier) {
        return duoProvider.getDuoAuthenticationService().getDuoClient();
    }

    protected Pair<String, String> createAuthUrlWithState(DuoSecurityMultifactorAuthenticationProvider provider, Map<String, Object> properties, RequestContext requestContext, String state) throws Exception {
        Authentication authentication = WebUtils.getAuthentication((RequestContext)requestContext);
        Principal principal = this.resolvePrincipal(authentication.getPrincipal(), requestContext);
        LOGGER.debug("Principal resolved for Duo Security as [{}]", (Object)principal);
        String principalId = principal.getId();
        String principalAttribute = provider.getDuoAuthenticationService().getProperties().getPrincipalAttribute();
        if (principal.getAttributes().containsKey(principalAttribute)) {
            principalId = ((List)principal.getAttributes().get(principalAttribute)).getFirst().toString();
        }
        String duoSecurityIdentifier = MultifactorAuthenticationWebflowUtils.getMultifactorAuthenticationProvider((RequestContext)requestContext);
        Client client = this.getDuoSecurityClient(requestContext, provider, duoSecurityIdentifier).getInstance();
        String effectiveState = state;
        if (provider.getDuoAuthenticationService().getProperties().getSessionStorageType().isTicketRegistry()) {
            WebApplicationService service = WebUtils.getService((RequestContext)requestContext);
            TransientSessionTicketFactory factory = (TransientSessionTicketFactory)this.ticketFactory.get(TransientSessionTicket.class);
            TransientSessionTicket ticket = factory.create(state, (Service)service, properties);
            this.ticketRegistry.addTicket((Ticket)ticket);
            effectiveState = ticket.getId();
            LOGGER.debug("Stored Duo Security session via [{}]", (Object)ticket);
        }
        return Pair.of((Object)client.createAuthUrl(principalId, effectiveState), (Object)effectiveState);
    }

    @Generated
    public DuoSecurityUniversalPromptPrepareLoginAction(BrowserWebStorageSessionStore duoUniversalPromptSessionStore, TicketRegistry ticketRegistry, TicketFactory ticketFactory, TenantExtractor tenantExtractor) {
        this.duoUniversalPromptSessionStore = duoUniversalPromptSessionStore;
        this.ticketRegistry = ticketRegistry;
        this.ticketFactory = ticketFactory;
        this.tenantExtractor = tenantExtractor;
    }
}

