/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.services.AbstractRegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicyContext;
import org.apereo.cas.util.CollectionUtils;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class ReturnEnvironmentAttributeReleasePolicy
extends AbstractRegisteredServiceAttributeReleasePolicy {
    private static final long serialVersionUID = 1239257723778012771L;
    @JsonProperty(value="environmentVariables")
    private Map<String, String> environmentVariables = new TreeMap<String, String>();
    @JsonProperty(value="systemProperties")
    private Map<String, String> systemProperties = new TreeMap<String, String>();

    @Override
    public Map<String, List<Object>> getAttributesInternal(RegisteredServiceAttributeReleasePolicyContext context, Map<String, List<Object>> resolvedAttributes) {
        LinkedHashMap<String, List<Object>> attributes = new LinkedHashMap<String, List<Object>>();
        attributes.putAll(this.fetchAttributes(this.environmentVariables, entry -> List.of(System.getenv((String)entry.getKey()))));
        attributes.putAll(this.fetchAttributes(this.systemProperties, entry -> List.of(System.getProperty((String)entry.getKey()))));
        List profiles = CollectionUtils.wrapList((Object[])context.getApplicationContext().getEnvironment().getActiveProfiles());
        attributes.put("applicationProfiles", profiles);
        return attributes;
    }

    protected Map fetchAttributes(Map<String, String> container, Function<Map.Entry<String, ?>, List<?>> valueMapper) {
        return container.entrySet().stream().map(entry -> Pair.of((Object)((String)entry.getValue()), (Object)((List)valueMapper.apply((Map.Entry<String, ?>)entry)))).collect(Collectors.toMap(Pair::getKey, entry -> (ArrayList)CollectionUtils.toCollection((Object)entry.getValue(), ArrayList.class)));
    }

    @Override
    @Generated
    public String toString() {
        return "ReturnEnvironmentAttributeReleasePolicy(super=" + super.toString() + ", environmentVariables=" + String.valueOf(this.environmentVariables) + ", systemProperties=" + String.valueOf(this.systemProperties) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReturnEnvironmentAttributeReleasePolicy)) {
            return false;
        }
        ReturnEnvironmentAttributeReleasePolicy other = (ReturnEnvironmentAttributeReleasePolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<String, String> this$environmentVariables = this.environmentVariables;
        Map<String, String> other$environmentVariables = other.environmentVariables;
        if (this$environmentVariables == null ? other$environmentVariables != null : !((Object)this$environmentVariables).equals(other$environmentVariables)) {
            return false;
        }
        Map<String, String> this$systemProperties = this.systemProperties;
        Map<String, String> other$systemProperties = other.systemProperties;
        return !(this$systemProperties == null ? other$systemProperties != null : !((Object)this$systemProperties).equals(other$systemProperties));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReturnEnvironmentAttributeReleasePolicy;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Map<String, String> $environmentVariables = this.environmentVariables;
        result = result * 59 + ($environmentVariables == null ? 43 : ((Object)$environmentVariables).hashCode());
        Map<String, String> $systemProperties = this.systemProperties;
        result = result * 59 + ($systemProperties == null ? 43 : ((Object)$systemProperties).hashCode());
        return result;
    }

    @Generated
    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @Generated
    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    @Generated
    public void setEnvironmentVariables(Map<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    @Generated
    public void setSystemProperties(Map<String, String> systemProperties) {
        this.systemProperties = systemProperties;
    }

    @Generated
    public ReturnEnvironmentAttributeReleasePolicy() {
    }
}

