/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.starter.actuate;

import java.util.stream.Stream;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.syncope.common.keymaster.client.api.DomainOps;
import org.apache.syncope.common.keymaster.client.api.model.Domain;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.provisioning.api.ConnectorManager;
import org.apache.syncope.core.provisioning.api.data.ConnInstanceDataBinder;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.Status;

public class ExternalResourcesHealthIndicator
implements HealthIndicator {
    protected static final Logger LOG = LoggerFactory.getLogger(ExternalResourcesHealthIndicator.class);
    protected final DomainOps domainOps;
    protected final ExternalResourceDAO resourceDAO;
    protected final ConnInstanceDataBinder connInstanceDataBinder;
    protected final ConnectorManager connectorManager;

    public ExternalResourcesHealthIndicator(DomainOps domainOps, ExternalResourceDAO resourceDAO, ConnInstanceDataBinder connInstanceDataBinder, ConnectorManager connectorManager) {
        this.domainOps = domainOps;
        this.resourceDAO = resourceDAO;
        this.connInstanceDataBinder = connInstanceDataBinder;
        this.connectorManager = connectorManager;
    }

    public Health health() {
        Health.Builder builder = new Health.Builder();
        MutableObject anyDown = new MutableObject((Object)false);
        Stream.concat(Stream.of("Master"), this.domainOps.list().stream().map(Domain::getKey)).forEach(arg_0 -> this.lambda$health$0(builder, (Mutable)anyDown, arg_0));
        builder.status((Boolean)anyDown.get() != false ? Status.DOWN : Status.UP);
        return builder.build();
    }

    private /* synthetic */ void lambda$health$0(Health.Builder builder, Mutable anyDown, String domain) {
        AuthContextUtils.runAsAdmin((String)domain, () -> this.resourceDAO.findAll().forEach(resource -> {
            Status status;
            try {
                this.connectorManager.createConnector(this.connectorManager.buildConnInstanceOverride(this.connInstanceDataBinder.getConnInstanceTO(resource.getConnector()), resource.getConfOverride(), resource.getCapabilitiesOverride())).test();
                status = Status.UP;
            }
            catch (Exception e) {
                status = Status.DOWN;
                LOG.debug("When checking {} in Domain {}", new Object[]{resource.getKey(), domain, e});
            }
            builder.withDetail(domain + "#" + resource.getKey(), (Object)status);
            if (status != Status.UP) {
                anyDown.setValue((Object)true);
            }
        }));
    }
}

