/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.wicket.spring.boot.starter.configuration.extensions.core.settings.requestlogger;

import com.giffing.wicket.spring.boot.context.extensions.ApplicationInitExtension;
import com.giffing.wicket.spring.boot.context.extensions.WicketApplicationInitConfiguration;
import com.giffing.wicket.spring.boot.context.extensions.boot.actuator.WicketAutoConfig;
import com.giffing.wicket.spring.boot.context.extensions.boot.actuator.WicketEndpointRepository;
import com.giffing.wicket.spring.boot.starter.configuration.extensions.core.settings.requestlogger.RequestLoggerSettingsProperties;
import lombok.Generated;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.settings.RequestLoggerSettings;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

@ApplicationInitExtension
@ConditionalOnProperty(prefix="wicket.core.settings.requestlogger", value={"enabled"}, matchIfMissing=false)
@EnableConfigurationProperties(value={RequestLoggerSettingsProperties.class})
public class RequestLoggerSettingsConfig
implements WicketApplicationInitConfiguration {
    private final RequestLoggerSettingsProperties props;
    private final WicketEndpointRepository wicketEndpointRepository;

    public void init(WebApplication webApplication) {
        RequestLoggerSettings wicketsRequestLoggerSettings = webApplication.getRequestLoggerSettings();
        wicketsRequestLoggerSettings.setRequestLoggerEnabled(this.props.isEnabled());
        wicketsRequestLoggerSettings.setRecordSessionSize(this.props.isRecordSessionSize());
        wicketsRequestLoggerSettings.setRequestsWindowSize(this.props.getRequestsWindowSize());
        this.wicketEndpointRepository.add(new WicketAutoConfig.Builder(this.getClass()).withDetail("properties", (Object)this.props).build());
    }

    @Generated
    public RequestLoggerSettingsConfig(RequestLoggerSettingsProperties props, WicketEndpointRepository wicketEndpointRepository) {
        this.props = props;
        this.wicketEndpointRepository = wicketEndpointRepository;
    }
}

