/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.common.validation;

import jakarta.validation.ConstraintValidatorContext;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.core.persistence.api.ApplicationContextProvider;
import org.apache.syncope.core.persistence.api.dao.PasswordManagementDAO;
import org.apache.syncope.core.persistence.api.entity.am.PasswordManagement;
import org.apache.syncope.core.persistence.common.validation.AbstractValidator;
import org.apache.syncope.core.persistence.common.validation.PasswordManagementCheck;

public class PasswordManagementValidator
extends AbstractValidator<PasswordManagementCheck, PasswordManagement> {
    public boolean isValid(PasswordManagement passwordManagement, ConstraintValidatorContext context) {
        boolean isValid;
        if (!passwordManagement.isEnabled()) {
            return true;
        }
        PasswordManagementDAO passwordManagementDAO = (PasswordManagementDAO)ApplicationContextProvider.getApplicationContext().getBean(PasswordManagementDAO.class);
        context.disableDefaultConstraintViolation();
        boolean bl = isValid = !passwordManagementDAO.isAnotherInstanceEnabled(passwordManagement.getKey());
        if (!isValid) {
            context.buildConstraintViolationWithTemplate(PasswordManagementValidator.getTemplate(EntityViolationType.MoreThanOneEnabled, "More than one enabled instance found")).addPropertyNode(PasswordManagement.class.getSimpleName()).addConstraintViolation();
        }
        return isValid;
    }
}

