/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.services.RegisteredServiceTicketGrantingTicketExpirationPolicy;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.expiration.HardTimeoutExpirationPolicy;
import org.apereo.cas.util.RegexUtils;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class DefaultRegisteredServiceTicketGrantingTicketExpirationPolicy
implements RegisteredServiceTicketGrantingTicketExpirationPolicy {
    private static final long serialVersionUID = 1122553887352573119L;
    private long maxTimeToLiveInSeconds;
    private Map<String, Long> userAgents = new HashMap<String, Long>();
    private Map<String, Long> ipAddresses = new HashMap<String, Long>();

    public Optional<ExpirationPolicy> toExpirationPolicy() {
        Long timeToLive;
        ClientInfo clientInfo = ClientInfoHolder.getClientInfo();
        if (clientInfo != null && !this.userAgents.isEmpty() && StringUtils.isNotBlank((CharSequence)clientInfo.getUserAgent()) && (timeToLive = this.userAgents.keySet().stream().filter(u -> RegexUtils.find((String)u, (String)clientInfo.getUserAgent())).findFirst().map(u -> this.userAgents.get(u)).orElse(-1L)) >= 0L) {
            return Optional.of(new HardTimeoutExpirationPolicy(timeToLive.longValue()));
        }
        if (clientInfo != null && !this.ipAddresses.isEmpty() && StringUtils.isNotBlank((CharSequence)clientInfo.getClientIpAddress()) && (timeToLive = this.ipAddresses.keySet().stream().filter(u -> RegexUtils.find((String)u, (String)clientInfo.getClientIpAddress())).findFirst().map(u -> this.ipAddresses.get(u)).orElse(-1L)) >= 0L) {
            return Optional.of(new HardTimeoutExpirationPolicy(timeToLive.longValue()));
        }
        return this.getMaxTimeToLiveInSeconds() > 0L ? Optional.of(new HardTimeoutExpirationPolicy(this.getMaxTimeToLiveInSeconds())) : Optional.empty();
    }

    @Generated
    public long getMaxTimeToLiveInSeconds() {
        return this.maxTimeToLiveInSeconds;
    }

    @Generated
    public Map<String, Long> getUserAgents() {
        return this.userAgents;
    }

    @Generated
    public Map<String, Long> getIpAddresses() {
        return this.ipAddresses;
    }

    @Generated
    public DefaultRegisteredServiceTicketGrantingTicketExpirationPolicy setMaxTimeToLiveInSeconds(long maxTimeToLiveInSeconds) {
        this.maxTimeToLiveInSeconds = maxTimeToLiveInSeconds;
        return this;
    }

    @Generated
    public DefaultRegisteredServiceTicketGrantingTicketExpirationPolicy setUserAgents(Map<String, Long> userAgents) {
        this.userAgents = userAgents;
        return this;
    }

    @Generated
    public DefaultRegisteredServiceTicketGrantingTicketExpirationPolicy setIpAddresses(Map<String, Long> ipAddresses) {
        this.ipAddresses = ipAddresses;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultRegisteredServiceTicketGrantingTicketExpirationPolicy)) {
            return false;
        }
        DefaultRegisteredServiceTicketGrantingTicketExpirationPolicy other = (DefaultRegisteredServiceTicketGrantingTicketExpirationPolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.maxTimeToLiveInSeconds != other.maxTimeToLiveInSeconds) {
            return false;
        }
        Map<String, Long> this$userAgents = this.userAgents;
        Map<String, Long> other$userAgents = other.userAgents;
        if (this$userAgents == null ? other$userAgents != null : !((Object)this$userAgents).equals(other$userAgents)) {
            return false;
        }
        Map<String, Long> this$ipAddresses = this.ipAddresses;
        Map<String, Long> other$ipAddresses = other.ipAddresses;
        return !(this$ipAddresses == null ? other$ipAddresses != null : !((Object)this$ipAddresses).equals(other$ipAddresses));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DefaultRegisteredServiceTicketGrantingTicketExpirationPolicy;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $maxTimeToLiveInSeconds = this.maxTimeToLiveInSeconds;
        result = result * 59 + (int)($maxTimeToLiveInSeconds >>> 32 ^ $maxTimeToLiveInSeconds);
        Map<String, Long> $userAgents = this.userAgents;
        result = result * 59 + ($userAgents == null ? 43 : ((Object)$userAgents).hashCode());
        Map<String, Long> $ipAddresses = this.ipAddresses;
        result = result * 59 + ($ipAddresses == null ? 43 : ((Object)$ipAddresses).hashCode());
        return result;
    }

    @Generated
    public DefaultRegisteredServiceTicketGrantingTicketExpirationPolicy(long maxTimeToLiveInSeconds, Map<String, Long> userAgents, Map<String, Long> ipAddresses) {
        this.maxTimeToLiveInSeconds = maxTimeToLiveInSeconds;
        this.userAgents = userAgents;
        this.ipAddresses = ipAddresses;
    }

    @Generated
    public DefaultRegisteredServiceTicketGrantingTicketExpirationPolicy() {
    }

    @Generated
    public String toString() {
        return "DefaultRegisteredServiceTicketGrantingTicketExpirationPolicy(maxTimeToLiveInSeconds=" + this.maxTimeToLiveInSeconds + ", userAgents=" + String.valueOf(this.userAgents) + ", ipAddresses=" + String.valueOf(this.ipAddresses) + ")";
    }
}

