/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.endpoints;

import java.util.LinkedHashMap;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceDefinition;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.events.OAuth20AccessTokenResponseEvent;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20TokenGeneratedResult;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestContext;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20AccessTokenResponseResult;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.device.OAuth20DeviceToken;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.web.servlet.ModelAndView;

public class OAuth20AccessTokenResponseEncoder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20AccessTokenResponseEncoder.class);
    private final OAuth20ConfigurationContext configurationContext;

    public ModelAndView encode(AccessTokenRequestContext tokenRequestContext, OAuth20TokenGeneratedResult result) {
        LOGGER.debug("Generating access token response for [{}]", (Object)result);
        long deviceRefreshInterval = Beans.newDuration((String)this.getConfigurationContext().getCasProperties().getAuthn().getOauth().getDeviceToken().getRefreshInterval()).toSeconds();
        ExpirationPolicyBuilder<OAuth20DeviceToken> deviceTokenExpirationPolicy = this.getConfigurationContext().getDeviceTokenExpirationPolicy();
        Long accessTokenTimeout = this.determineAccessTokenTimeoutInSeconds(result);
        OAuth20AccessTokenResponseResult tokenResult = OAuth20AccessTokenResponseResult.builder().registeredService((RegisteredService)tokenRequestContext.getRegisteredService()).service(tokenRequestContext.getService()).accessTokenTimeout(accessTokenTimeout.longValue()).deviceRefreshInterval(deviceRefreshInterval).deviceTokenTimeout(deviceTokenExpirationPolicy.buildTicketExpirationPolicyFor((RegisteredServiceDefinition)tokenRequestContext.getRegisteredService()).getTimeToLive().longValue()).responseType(result.getResponseType().orElse(OAuth20ResponseTypes.NONE)).casProperties(this.getConfigurationContext().getCasProperties()).generatedToken(result).grantType(result.getGrantType().orElse(OAuth20GrantTypes.NONE)).userProfile(tokenRequestContext.getUserProfile()).requestedTokenType(tokenRequestContext.getRequestedTokenType()).tokenExchangeAudience(tokenRequestContext.getTokenExchangeAudience()).tokenExchangeResource(tokenRequestContext.getTokenExchangeResource()).build();
        ModelAndView generatedTokenResult = this.getConfigurationContext().getAccessTokenResponseGenerator().generate(tokenResult);
        LinkedHashMap<String, Object> context = new LinkedHashMap<String, Object>(generatedTokenResult.getModel());
        if (generatedTokenResult.getStatus() != null) {
            context.put("status", generatedTokenResult.getStatus());
        }
        context.put("service", tokenResult.getService().getId());
        Optional.ofNullable(tokenRequestContext.getToken()).ifPresent(token -> context.put("token", token.getId()));
        context.put("client_id", tokenRequestContext.getRegisteredService().getClientId());
        context.put("grant_type", tokenRequestContext.getGrantType().getType());
        context.put("response_type", tokenRequestContext.getResponseType().getType());
        LoggingUtils.protocolMessage((String)"OAuth/OpenID Connect Token Response", context);
        this.configurationContext.getApplicationContext().publishEvent((ApplicationEvent)new OAuth20AccessTokenResponseEvent(this, ClientInfoHolder.getClientInfo(), context));
        return generatedTokenResult;
    }

    protected Long determineAccessTokenTimeoutInSeconds(OAuth20TokenGeneratedResult accessTokenResult) {
        return OAuth20Utils.getAccessTokenTimeout(accessTokenResult);
    }

    @Generated
    public OAuth20AccessTokenResponseEncoder(OAuth20ConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
    }

    @Generated
    public OAuth20ConfigurationContext getConfigurationContext() {
        return this.configurationContext;
    }
}

