/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.services;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicyContext;
import org.apereo.cas.support.saml.SamlIdPUtils;
import org.apereo.cas.support.saml.services.BaseSamlRegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.support.saml.services.idp.metadata.MetadataEntityAttributeQuery;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceMetadataAdaptor;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataEntityAttributesAttributeReleasePolicy
extends BaseSamlRegisteredServiceAttributeReleasePolicy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(MetadataEntityAttributesAttributeReleasePolicy.class);
    private static final long serialVersionUID = -3483733307124962357L;
    private String entityAttribute;
    private String entityAttributeFormat;
    private Set<String> entityAttributeValues = new LinkedHashSet<String>();

    @Override
    protected Map<String, List<Object>> getAttributesForSamlRegisteredService(Map<String, List<Object>> attributes, SamlRegisteredServiceCachingMetadataResolver resolver, SamlRegisteredServiceMetadataAdaptor facade, EntityDescriptor entityDescriptor, RegisteredServiceAttributeReleasePolicyContext context) {
        LOGGER.trace("Loading entity attribute predicate filter for candidate [{}] with values [{}]", (Object)this.getEntityAttribute(), this.getEntityAttributeValues());
        boolean match = SamlIdPUtils.doesEntityDescriptorMatchEntityAttribute(entityDescriptor, List.of(MetadataEntityAttributeQuery.of(this.getEntityAttribute(), this.getEntityAttributeFormat(), this.getEntityAttributeValues())));
        if (match) {
            LOGGER.debug("Authorizing release of allowed attributes [{}] for entity id [{}]", attributes, (Object)entityDescriptor.getEntityID());
            return this.authorizeReleaseOfAllowedAttributes(context, attributes);
        }
        LOGGER.debug("Unable to authorize attribute release for entity attribute category [{}] and value(s) [{}] to entity id [{}]", new Object[]{this.getEntityAttribute(), this.getEntityAttributeValues(), entityDescriptor.getEntityID()});
        return new HashMap<String, List<Object>>();
    }

    @Generated
    public String toString() {
        return "MetadataEntityAttributesAttributeReleasePolicy(super=" + super.toString() + ", entityAttribute=" + this.entityAttribute + ", entityAttributeFormat=" + this.entityAttributeFormat + ", entityAttributeValues=" + String.valueOf(this.entityAttributeValues) + ")";
    }

    @Generated
    public String getEntityAttribute() {
        return this.entityAttribute;
    }

    @Generated
    public String getEntityAttributeFormat() {
        return this.entityAttributeFormat;
    }

    @Generated
    public Set<String> getEntityAttributeValues() {
        return this.entityAttributeValues;
    }

    @Generated
    public void setEntityAttribute(String entityAttribute) {
        this.entityAttribute = entityAttribute;
    }

    @Generated
    public void setEntityAttributeFormat(String entityAttributeFormat) {
        this.entityAttributeFormat = entityAttributeFormat;
    }

    @Generated
    public void setEntityAttributeValues(Set<String> entityAttributeValues) {
        this.entityAttributeValues = entityAttributeValues;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetadataEntityAttributesAttributeReleasePolicy)) {
            return false;
        }
        MetadataEntityAttributesAttributeReleasePolicy other = (MetadataEntityAttributesAttributeReleasePolicy)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$entityAttribute = this.entityAttribute;
        String other$entityAttribute = other.entityAttribute;
        if (this$entityAttribute == null ? other$entityAttribute != null : !this$entityAttribute.equals(other$entityAttribute)) {
            return false;
        }
        String this$entityAttributeFormat = this.entityAttributeFormat;
        String other$entityAttributeFormat = other.entityAttributeFormat;
        if (this$entityAttributeFormat == null ? other$entityAttributeFormat != null : !this$entityAttributeFormat.equals(other$entityAttributeFormat)) {
            return false;
        }
        Set<String> this$entityAttributeValues = this.entityAttributeValues;
        Set<String> other$entityAttributeValues = other.entityAttributeValues;
        return !(this$entityAttributeValues == null ? other$entityAttributeValues != null : !((Object)this$entityAttributeValues).equals(other$entityAttributeValues));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MetadataEntityAttributesAttributeReleasePolicy;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $entityAttribute = this.entityAttribute;
        result = result * 59 + ($entityAttribute == null ? 43 : $entityAttribute.hashCode());
        String $entityAttributeFormat = this.entityAttributeFormat;
        result = result * 59 + ($entityAttributeFormat == null ? 43 : $entityAttributeFormat.hashCode());
        Set<String> $entityAttributeValues = this.entityAttributeValues;
        result = result * 59 + ($entityAttributeValues == null ? 43 : ((Object)$entityAttributeValues).hashCode());
        return result;
    }
}

