/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.SyncopeClientCompositeException;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.request.AnyCR;
import org.apache.syncope.common.lib.request.AnyUR;
import org.apache.syncope.common.lib.request.AttrPatch;
import org.apache.syncope.common.lib.request.MembershipUR;
import org.apache.syncope.common.lib.request.RelationshipUR;
import org.apache.syncope.common.lib.request.StringPatchItem;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.AttributableTO;
import org.apache.syncope.common.lib.to.ConnObject;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.common.lib.to.RelationshipTO;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.persistence.api.attrvalue.PlainAttrValidationManager;
import org.apache.syncope.core.persistence.api.dao.AllowedSchemas;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeClassDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.RealmSearchDAO;
import org.apache.syncope.core.persistence.api.dao.RelationshipTypeDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.Attributable;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.Groupable;
import org.apache.syncope.core.persistence.api.entity.Membership;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.Relatable;
import org.apache.syncope.core.persistence.api.entity.Relationship;
import org.apache.syncope.core.persistence.api.entity.RelationshipType;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.AccountGetter;
import org.apache.syncope.core.provisioning.api.DerAttrHandler;
import org.apache.syncope.core.provisioning.api.IntAttrName;
import org.apache.syncope.core.provisioning.api.IntAttrNameParser;
import org.apache.syncope.core.provisioning.api.MappingManager;
import org.apache.syncope.core.provisioning.api.PlainAttrGetter;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.jexl.JexlTools;
import org.apache.syncope.core.provisioning.java.data.AttributableDataBinder;
import org.apache.syncope.core.provisioning.java.pushpull.OutboundMatcher;
import org.apache.syncope.core.provisioning.java.utils.ConnObjectUtils;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ConnectorObjectBuilder;
import org.identityconnectors.framework.common.objects.Uid;

abstract class AnyDataBinder
extends AttributableDataBinder {
    protected final AnyTypeDAO anyTypeDAO;
    protected final RealmSearchDAO realmSearchDAO;
    protected final AnyTypeClassDAO anyTypeClassDAO;
    protected final AnyObjectDAO anyObjectDAO;
    protected final UserDAO userDAO;
    protected final GroupDAO groupDAO;
    protected final ExternalResourceDAO resourceDAO;
    protected final RelationshipTypeDAO relationshipTypeDAO;
    protected final EntityFactory entityFactory;
    protected final AnyUtilsFactory anyUtilsFactory;
    protected final OutboundMatcher outboundMatcher;

    protected static void fillTO(Any any, AnyTO anyTO, Map<String, String> derAttrs, Collection<? extends ExternalResource> resources) {
        anyTO.setRealm(any.getRealm().getFullPath());
        Optional.ofNullable(any.getUManager()).map(Entity::getKey).ifPresent(arg_0 -> ((AnyTO)anyTO).setUManager(arg_0));
        Optional.ofNullable(any.getGManager()).map(Entity::getKey).ifPresent(arg_0 -> ((AnyTO)anyTO).setGManager(arg_0));
        anyTO.getAuxClasses().addAll(any.getAuxClasses().stream().map(Entity::getKey).toList());
        any.getPlainAttrs().forEach(plainAttr -> anyTO.getPlainAttrs().add(new Attr.Builder(plainAttr.getSchema()).values((Collection)plainAttr.getValuesAsStrings()).build()));
        derAttrs.forEach((schema, value) -> anyTO.getDerAttrs().add(new Attr.Builder(schema).value(value).build()));
        anyTO.getResources().addAll(resources.stream().map(Entity::getKey).collect(Collectors.toSet()));
    }

    protected static RelationshipTO getRelationshipTO(Collection<PlainAttr> plainAttrs, Map<String, String> derAttrs, String relationshipType, RelationshipTO.End end, Any otherEnd) {
        String string;
        RelationshipTO.Builder builder = new RelationshipTO.Builder(relationshipType, end);
        String string2 = otherEnd.getType().getKey();
        String string3 = otherEnd.getKey();
        if (otherEnd instanceof User) {
            User user = (User)otherEnd;
            string = user.getUsername();
        } else if (otherEnd instanceof Group) {
            Group group = (Group)otherEnd;
            string = group.getName();
        } else {
            string = ((AnyObject)otherEnd).getName();
        }
        RelationshipTO relationshipTO = builder.otherEnd(string2, string3, string).build();
        plainAttrs.forEach(plainAttr -> relationshipTO.getPlainAttrs().add(new Attr.Builder(plainAttr.getSchema()).values((Collection)plainAttr.getValuesAsStrings()).build()));
        derAttrs.forEach((schema, value) -> relationshipTO.getDerAttrs().add(new Attr.Builder(schema).value(value).build()));
        return relationshipTO;
    }

    protected static MembershipTO getMembershipTO(Collection<PlainAttr> plainAttrs, Map<String, String> derAttrs, Membership<? extends Any> membership) {
        MembershipTO membershipTO = new MembershipTO.Builder(((Group)membership.getRightEnd()).getKey()).groupName(((Group)membership.getRightEnd()).getName()).build();
        plainAttrs.forEach(plainAttr -> membershipTO.getPlainAttrs().add(new Attr.Builder(plainAttr.getSchema()).values((Collection)plainAttr.getValuesAsStrings()).build()));
        derAttrs.forEach((schema, value) -> membershipTO.getDerAttrs().add(new Attr.Builder(schema).value(value).build()));
        return membershipTO;
    }

    protected AnyDataBinder(AnyTypeDAO anyTypeDAO, RealmSearchDAO realmSearchDAO, AnyTypeClassDAO anyTypeClassDAO, AnyObjectDAO anyObjectDAO, UserDAO userDAO, GroupDAO groupDAO, PlainSchemaDAO plainSchemaDAO, ExternalResourceDAO resourceDAO, RelationshipTypeDAO relationshipTypeDAO, EntityFactory entityFactory, AnyUtilsFactory anyUtilsFactory, DerAttrHandler derAttrHandler, MappingManager mappingManager, IntAttrNameParser intAttrNameParser, OutboundMatcher outboundMatcher, PlainAttrValidationManager validator, JexlTools jexlTools) {
        super(plainSchemaDAO, validator, derAttrHandler, mappingManager, intAttrNameParser, jexlTools);
        this.anyTypeDAO = anyTypeDAO;
        this.realmSearchDAO = realmSearchDAO;
        this.anyTypeClassDAO = anyTypeClassDAO;
        this.anyObjectDAO = anyObjectDAO;
        this.userDAO = userDAO;
        this.groupDAO = groupDAO;
        this.resourceDAO = resourceDAO;
        this.relationshipTypeDAO = relationshipTypeDAO;
        this.entityFactory = entityFactory;
        this.anyUtilsFactory = anyUtilsFactory;
        this.outboundMatcher = outboundMatcher;
    }

    protected void setRealm(Any any, AnyUR anyUR) {
        if (anyUR.getRealm() != null && StringUtils.isNotBlank((CharSequence)((CharSequence)anyUR.getRealm().getValue()))) {
            this.realmSearchDAO.findByFullPath((String)anyUR.getRealm().getValue()).ifPresentOrElse(arg_0 -> ((Any)any).setRealm(arg_0), () -> LOG.debug("Invalid realm specified: {}, ignoring", anyUR.getRealm().getValue()));
        }
    }

    protected Map<String, ConnObject> onResources(Any any, Collection<String> resources, String password, Set<String> changePwdRes) {
        HashMap<String, ConnObject> onResources = new HashMap<String, ConnObject>();
        resources.stream().map(arg_0 -> ((ExternalResourceDAO)this.resourceDAO).findById(arg_0)).flatMap(Optional::stream).forEach(resource -> resource.getProvisionByAnyType(any.getType().getKey()).ifPresent(provision -> MappingUtils.getConnObjectKeyItem(provision).ifPresent(keyItem -> {
            ConnObject connObjectTO;
            MappingManager.PreparedAttrs prepared = this.mappingManager.prepareAttrsFromAny(any, password, changePwdRes.contains(resource.getKey()), Boolean.valueOf(true), resource, provision);
            if (StringUtils.isBlank((CharSequence)prepared.connObjectLink())) {
                connObjectTO = ConnObjectUtils.getConnObjectTO(null, prepared.attributes());
            } else {
                ConnectorObject connectorObject = new ConnectorObjectBuilder().addAttributes((Collection)prepared.attributes()).addAttribute(new Attribute[]{new Uid(prepared.connObjectLink())}).addAttribute(new Attribute[]{AttributeBuilder.build((String)keyItem.getExtAttrName(), (Object[])new Object[]{prepared.connObjectLink()})}).build();
                connObjectTO = ConnObjectUtils.getConnObjectTO(this.outboundMatcher.getFIQL(connectorObject, (ExternalResource)resource, (Provision)provision), connectorObject.getAttributes());
            }
            onResources.put(resource.getKey(), connObjectTO);
        })));
        return onResources;
    }

    protected List<String> evaluateMandatoryCondition(ExternalResource resource, Provision provision, Any any) {
        ArrayList<String> missingAttrNames = new ArrayList<String>();
        MappingUtils.getPropagationItems(provision.getMapping().getItems().stream()).forEach(item -> {
            AttrSchemaType schemaType;
            MappingManager.IntValues intValues;
            IntAttrName intAttrName = null;
            try {
                intAttrName = this.intAttrNameParser.parse(item.getIntAttrName(), any.getType().getKind());
            }
            catch (ParseException e) {
                LOG.error("Invalid intAttrName '{}', ignoring", (Object)item.getIntAttrName(), (Object)e);
            }
            if (intAttrName != null && intAttrName.getSchemaInfo() != null && (intValues = this.mappingManager.getIntValues(resource, provision, item, intAttrName, schemaType = intAttrName.getSchemaInfo().schema() instanceof PlainSchema ? intAttrName.getSchemaInfo().schema().getType() : AttrSchemaType.String, any, AccountGetter.DEFAULT, PlainAttrGetter.DEFAULT)).values().isEmpty() && this.jexlTools.evaluateMandatoryCondition(item.getMandatoryCondition(), (Attributable)any, this.derAttrHandler)) {
                missingAttrNames.add(item.getIntAttrName());
            }
        });
        return missingAttrNames;
    }

    protected SyncopeClientException checkMandatoryOnResources(Any any, Collection<? extends ExternalResource> resources) {
        SyncopeClientException reqValMissing = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RequiredValuesMissing);
        resources.stream().filter(ExternalResource::isEnforceMandatoryCondition).forEach(resource -> resource.getProvisionByAnyType(any.getType().getKey()).ifPresent(provision -> {
            List<String> missingAttrNames = this.evaluateMandatoryCondition((ExternalResource)resource, (Provision)provision, any);
            if (!missingAttrNames.isEmpty()) {
                LOG.error("Mandatory schemas {} not provided with values", missingAttrNames);
                reqValMissing.getElements().addAll(missingAttrNames);
            }
        }));
        return reqValMissing;
    }

    protected SyncopeClientException checkMandatory(Any any, AnyUtils anyUtils) {
        SyncopeClientException reqValMissing = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RequiredValuesMissing);
        AllowedSchemas allowedPlainSchemas = anyUtils.dao().findAllowedSchemas(any, PlainSchema.class);
        allowedPlainSchemas.self().forEach(schema -> this.checkMandatory((PlainSchema)schema, any.getPlainAttr(schema.getKey()).orElse(null), (Attributable)any, reqValMissing));
        if (any instanceof Groupable) {
            Groupable groupable = (Groupable)any;
            allowedPlainSchemas.memberships().forEach((group, schemas) -> {
                Membership membership = groupable.getMembership(group.getKey()).orElse(null);
                schemas.forEach(schema -> this.checkMandatory((PlainSchema)schema, groupable.getPlainAttr(schema.getKey(), membership).orElse(null), (Attributable)any, reqValMissing));
            });
        }
        if (any instanceof Relatable) {
            Relatable relatable = (Relatable)any;
            allowedPlainSchemas.relationshipTypes().forEach((relationshipType, schemas) -> {
                List rels = relatable.getRelationships(relationshipType.getKey());
                rels.forEach(rel -> schemas.forEach(schema -> this.checkMandatory((PlainSchema)schema, relatable.getPlainAttr(schema.getKey(), rel).orElse(null), (Attributable)any, reqValMissing)));
            });
        }
        return reqValMissing;
    }

    protected void processAttrPatch(AnyTO anyTO, Any any, AttrPatch patch, PlainSchema schema, PlainAttr attr, SyncopeClientException invalidValues) {
        switch (patch.getOperation()) {
            case ADD_REPLACE: {
                List valuesToBeAdded;
                if (schema.isUniqueConstraint()) {
                    if (attr.getUniqueValue() != null && !patch.getAttr().getValues().isEmpty() && !((String)patch.getAttr().getValues().getFirst()).equals(attr.getUniqueValue().getValueAsString())) {
                        attr.setUniqueValue(null);
                    }
                } else {
                    attr.getValues().clear();
                }
                if (!((valuesToBeAdded = patch.getAttr().getValues()).isEmpty() || schema.isUniqueConstraint() && attr.getUniqueValue() != null && ((String)valuesToBeAdded.getFirst()).equals(attr.getUniqueValue().getValueAsString()))) {
                    this.fillAttr((AttributableTO)anyTO, valuesToBeAdded, schema, attr, invalidValues);
                }
                if (!attr.getValuesAsStrings().isEmpty()) break;
                any.remove(attr);
                break;
            }
            default: {
                any.remove(attr);
            }
        }
    }

    protected void fill(AnyTO anyTO, Relatable<?, ?> any, AnyUR anyUR, PropagationByResource<String> propByRes, AnyUtils anyUtils, SyncopeClientCompositeException scce) {
        SyncopeClientException reqValMissing;
        User manager;
        PropagationByResource managerPropByRes = new PropagationByResource();
        if (anyUR.getUManager() != null) {
            if (anyUR.getUManager().getValue() == null) {
                if (any.getUManager() != null) {
                    any.setUManager(null);
                    managerPropByRes.addAll(ResourceOperation.UPDATE, anyUtils.dao().findAllResourceKeys(any.getKey()));
                }
            } else {
                manager = this.userDAO.findById((String)anyUR.getUManager().getValue()).orElse(null);
                if (manager == null) {
                    LOG.debug("Unable to find user manager for {} {} by key {}", new Object[]{any.getKey(), anyUtils.anyTypeKind(), anyUR.getUManager().getValue()});
                    any.setUManager(null);
                } else {
                    any.setUManager(manager);
                    managerPropByRes.addAll(ResourceOperation.UPDATE, anyUtils.dao().findAllResourceKeys(any.getKey()));
                }
            }
        }
        if (anyUR.getGManager() != null) {
            if (anyUR.getGManager().getValue() == null) {
                if (any.getGManager() != null) {
                    any.setGManager(null);
                    managerPropByRes.addAll(ResourceOperation.UPDATE, anyUtils.dao().findAllResourceKeys(any.getKey()));
                }
            } else {
                manager = this.groupDAO.findById((String)anyUR.getGManager().getValue()).orElse(null);
                if (manager == null) {
                    LOG.debug("Unable to find group manager for {} {} by key {}", new Object[]{any.getKey(), anyUtils.anyTypeKind(), anyUR.getGManager().getValue()});
                    any.setGManager(null);
                } else {
                    any.setGManager((Group)manager);
                    managerPropByRes.addAll(ResourceOperation.UPDATE, anyUtils.dao().findAllResourceKeys(any.getKey()));
                }
            }
        }
        propByRes.merge(managerPropByRes);
        for (Object patch2 : anyUR.getAuxClasses()) {
            this.anyTypeClassDAO.findById((String)patch2.getValue()).ifPresentOrElse(arg_0 -> AnyDataBinder.lambda$fill$0((StringPatchItem)patch2, any, arg_0), () -> AnyDataBinder.lambda$fill$1((StringPatchItem)patch2));
        }
        HashSet<Pair> relationships = new HashSet<Pair>();
        for (RelationshipUR patch3 : anyUR.getRelationships().stream().filter(patch -> patch.getType() != null && patch.getOtherEndKey() != null).toList()) {
            RelationshipType relationshipType = this.relationshipTypeDAO.findById(patch3.getType()).orElse(null);
            if (relationshipType == null) {
                LOG.debug("Ignoring invalid relationship type {}", (Object)patch3.getType());
                continue;
            }
            switch (patch3.getOperation()) {
                case DELETE: {
                    any.getRelationship(relationshipType, patch3.getOtherEndKey()).ifPresentOrElse(relationship -> {
                        anyUtils.remove(any, relationship);
                        propByRes.addAll(ResourceOperation.UPDATE, this.anyObjectDAO.findAllResourceKeys(((AnyObject)relationship.getRightEnd()).getKey()));
                    }, () -> LOG.debug("No relationship ({},{},{}) was found, nothing to delete", new Object[]{anyTO.getKey(), relationshipType.getKey(), patch3.getOtherEndKey()}));
                    break;
                }
                case ADD_REPLACE: {
                    AnyObject otherEnd = this.anyObjectDAO.findById(patch3.getOtherEndKey()).orElse(null);
                    if (otherEnd == null) {
                        LOG.debug("Ignoring invalid any object {}", (Object)patch3.getOtherEndKey());
                        break;
                    }
                    if (!relationshipType.getRightEndAnyType().equals((Object)otherEnd.getType())) {
                        LOG.debug("Ignoring mismatching anyType {}", (Object)otherEnd.getType().getKey());
                        break;
                    }
                    if (relationships.contains(Pair.of((Object)relationshipType.getKey(), (Object)otherEnd.getKey()))) {
                        SyncopeClientException assigned = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRelationship);
                        assigned.getElements().add(otherEnd.getType().getKey() + " " + otherEnd.getName() + " in relationship " + relationshipType.getKey());
                        scce.addException(assigned);
                        break;
                    }
                    relationships.add(Pair.of((Object)relationshipType.getKey(), (Object)otherEnd.getKey()));
                    Relationship relationship2 = any.getRelationship(relationshipType, patch3.getOtherEndKey()).orElse(null);
                    if (relationship2 == null) {
                        relationship2 = anyUtils.add(any, relationshipType, otherEnd);
                    } else {
                        any.getPlainAttrs(relationship2).forEach(arg_0 -> any.remove(arg_0));
                    }
                    this.relationshipPlainAttrsOnUpdate(patch3.getPlainAttrs(), anyTO, any, relationship2, scce);
                    propByRes.addAll(ResourceOperation.UPDATE, this.anyObjectDAO.findAllResourceKeys(otherEnd.getKey()));
                    break;
                }
            }
        }
        for (RelationshipUR patch3 : anyUR.getResources()) {
            this.resourceDAO.findById((String)patch3.getValue()).ifPresentOrElse(arg_0 -> AnyDataBinder.lambda$fill$5((StringPatchItem)patch3, any, arg_0), () -> AnyDataBinder.lambda$fill$6((StringPatchItem)patch3));
        }
        Set resources = anyUtils.getAllResources(any);
        SyncopeClientException invalidValues = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidValues);
        anyUR.getPlainAttrs().stream().filter(patch -> patch.getAttr() != null).forEach(patch -> this.getPlainSchema(patch.getAttr().getSchema()).ifPresentOrElse(schema -> {
            PlainAttr attr = any.getPlainAttr(schema.getKey()).orElse(null);
            if (attr == null) {
                LOG.debug("No plain attribute found for schema {}", schema);
                if (patch.getOperation() == PatchOperation.ADD_REPLACE) {
                    attr = new PlainAttr();
                    attr.setPlainSchema(schema);
                    any.add(attr);
                }
            }
            if (attr != null) {
                this.processAttrPatch(anyTO, (Any)any, (AttrPatch)patch, (PlainSchema)schema, attr, invalidValues);
            }
        }, () -> LOG.debug("Invalid {} {}, ignoring...", (Object)PlainSchema.class.getSimpleName(), (Object)patch.getAttr().getSchema())));
        if (!invalidValues.isEmpty()) {
            scce.addException(invalidValues);
        }
        if (!(reqValMissing = this.checkMandatory((Any)any, anyUtils)).isEmpty()) {
            scce.addException(reqValMissing);
        }
        if (!(reqValMissing = this.checkMandatoryOnResources((Any)any, resources)).isEmpty()) {
            scce.addException(reqValMissing);
        }
    }

    protected void memberships(Set<MembershipUR> memberships, AnyTO anyTO, Groupable<?, ?, ?> any, Consumer<Group> groupProcessor, PropagationByResource<String> propByRes, AnyUtils anyUtils, SyncopeClientCompositeException scce) {
        HashSet groups = new HashSet();
        memberships.stream().filter(patch -> patch.getGroup() != null).forEach(patch -> {
            switch (patch.getOperation()) {
                case DELETE: {
                    any.getMembership(patch.getGroup()).ifPresentOrElse(membership -> {
                        anyUtils.remove(any, membership);
                        propByRes.addAll(ResourceOperation.UPDATE, this.groupDAO.findAllResourceKeys(((Group)membership.getRightEnd()).getKey()));
                    }, () -> LOG.debug("No membership ({},{}) was found, nothing to delete", (Object)anyTO.getKey(), (Object)patch.getGroup()));
                    break;
                }
                case ADD_REPLACE: {
                    Group group = this.groupDAO.findById(patch.getGroup()).orElse(null);
                    if (group == null) {
                        LOG.debug("Ignoring invalid group {}", (Object)patch.getGroup());
                        break;
                    }
                    if (groups.contains(group.getKey())) {
                        LOG.error("Multiple patches for group {} of {} were found", (Object)group, (Object)any);
                        SyncopeClientException assigned = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidMembership);
                        assigned.getElements().add("Multiple patches for group " + group.getName() + " were found");
                        scce.addException(assigned);
                        break;
                    }
                    groups.add(group.getKey());
                    Membership membership2 = any.getMembership(patch.getGroup()).orElse(null);
                    if (membership2 == null) {
                        membership2 = anyUtils.add(any, group);
                    } else {
                        any.getPlainAttrs(membership2).forEach(arg_0 -> ((Groupable)any).remove(arg_0));
                    }
                    this.membershipPlainAttrsOnUpdate(patch.getPlainAttrs(), anyTO, any, membership2, scce);
                    propByRes.addAll(ResourceOperation.UPDATE, this.groupDAO.findAllResourceKeys(group.getKey()));
                    groupProcessor.accept(group);
                    break;
                }
            }
        });
    }

    protected void fill(AnyTO anyTO, Relatable<?, ?> any, AnyCR anyCR, AnyUtils anyUtils, SyncopeClientCompositeException scce) {
        SyncopeClientException requiredValuesMissing;
        if (anyCR.getUManager() != null) {
            this.userDAO.findById(anyCR.getUManager()).ifPresentOrElse(arg_0 -> any.setUManager(arg_0), () -> LOG.warn("Ignoring invalid user specified as manager: {}", (Object)anyCR.getUManager()));
        }
        if (anyCR.getGManager() != null) {
            this.groupDAO.findById(anyCR.getGManager()).ifPresentOrElse(arg_0 -> any.setGManager(arg_0), () -> LOG.warn("Ignoring invalid group specified as manager: {}", (Object)anyCR.getGManager()));
        }
        any.getAuxClasses().clear();
        anyCR.getAuxClasses().stream().map(arg_0 -> ((AnyTypeClassDAO)this.anyTypeClassDAO).findById(arg_0)).flatMap(Optional::stream).forEach(auxClass -> {
            if (auxClass == null) {
                LOG.debug("Invalid {} {}, ignoring...", (Object)AnyTypeClass.class.getSimpleName(), auxClass);
            } else {
                any.add(auxClass);
            }
        });
        HashSet relationships = new HashSet();
        anyCR.getRelationships().forEach(relationshipTO -> {
            RelationshipType relationshipType = this.relationshipTypeDAO.findById(relationshipTO.getType()).orElse(null);
            AnyObject otherEnd = this.anyObjectDAO.findById(relationshipTO.getOtherEndKey()).orElse(null);
            if (relationshipType == null) {
                LOG.debug("Ignoring invalid relationship type {}", (Object)relationshipTO.getType());
            } else if (otherEnd == null) {
                LOG.debug("Ignoring invalid anyObject {}", (Object)relationshipTO.getOtherEndKey());
            } else if (!relationshipType.getRightEndAnyType().equals((Object)otherEnd.getType())) {
                LOG.debug("Ignoring mismatching anyType {}", (Object)relationshipTO.getOtherEndType());
            } else if (relationshipTO.getEnd() == RelationshipTO.End.RIGHT) {
                SyncopeClientException noRight = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRelationship);
                noRight.getElements().add("Relationships shall be created or updated only from their left end");
                scce.addException(noRight);
            } else if (relationships.contains(Pair.of((Object)otherEnd.getKey(), (Object)relationshipType.getKey()))) {
                SyncopeClientException assigned = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRelationship);
                assigned.getElements().add(otherEnd.getType().getKey() + " " + otherEnd.getName() + " in relationship " + relationshipTO.getType());
                scce.addException(assigned);
            } else {
                relationships.add(Pair.of((Object)otherEnd.getKey(), (Object)relationshipType.getKey()));
                Relationship relationship = anyUtils.add(any, relationshipType, otherEnd);
                this.relationshipPlainAttrsOnCreate(anyTO, any, (Relationship<?, ?>)relationship, (RelationshipTO)relationshipTO, scce);
            }
        });
        SyncopeClientException invalidValues = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidValues);
        anyCR.getPlainAttrs().stream().filter(attrTO -> !attrTO.getValues().isEmpty()).forEach(attrTO -> this.getPlainSchema(attrTO.getSchema()).ifPresent(schema -> {
            PlainAttr attr = any.getPlainAttr(schema.getKey()).orElseGet(() -> {
                PlainAttr newAttr = new PlainAttr();
                newAttr.setPlainSchema(schema);
                return newAttr;
            });
            this.fillAttr((AttributableTO)anyTO, attrTO.getValues(), (PlainSchema)schema, attr, invalidValues);
            if (!attr.getValuesAsStrings().isEmpty()) {
                any.add(attr);
            }
        }));
        if (!invalidValues.isEmpty()) {
            scce.addException(invalidValues);
        }
        if (!(requiredValuesMissing = this.checkMandatory((Any)any, anyUtils)).isEmpty()) {
            scce.addException(requiredValuesMissing);
        }
        anyCR.getResources().forEach(resource -> this.resourceDAO.findById(resource).ifPresentOrElse(arg_0 -> ((Relatable)any).add(arg_0), () -> LOG.debug("Invalid {} {}, ignoring...", (Object)ExternalResource.class.getSimpleName(), resource)));
        requiredValuesMissing = this.checkMandatoryOnResources((Any)any, anyUtils.getAllResources(any));
        if (!requiredValuesMissing.isEmpty()) {
            scce.addException(requiredValuesMissing);
        }
    }

    protected void memberships(List<MembershipTO> memberships, AnyTO anyTO, Groupable<?, ?, ?> any, AnyUtils anyUtils, SyncopeClientCompositeException scce) {
        HashSet groups = new HashSet();
        memberships.forEach(membershipTO -> {
            Group group;
            Group group2 = group = membershipTO.getGroupKey() == null ? (Group)this.groupDAO.findByName(membershipTO.getGroupName()).orElse(null) : (Group)this.groupDAO.findById(membershipTO.getGroupKey()).orElse(null);
            if (group == null) {
                LOG.debug("Ignoring invalid group {}", (Object)(membershipTO.getGroupKey() + " / " + membershipTO.getGroupName()));
            } else if (groups.contains(group.getKey())) {
                LOG.error("{} was already assigned to {}", (Object)group, (Object)any);
                SyncopeClientException assigned = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidMembership);
                assigned.getElements().add("Group " + group.getName() + " was already assigned");
                scce.addException(assigned);
            } else {
                groups.add(group.getKey());
                Membership newMembership = anyUtils.add(any, group);
                this.membershipPlainAttrsOnCreate(anyTO, any, (Membership<?>)newMembership, (MembershipTO)membershipTO, scce);
            }
        });
    }

    protected void relationshipPlainAttrsOnCreate(AnyTO anyTO, Relatable<?, ?> any, Relationship<?, ?> relationship, RelationshipTO relationshipTO, SyncopeClientCompositeException scce) {
        SyncopeClientException invalidValues = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidValues);
        relationshipTO.getPlainAttrs().stream().filter(attrTO -> !attrTO.getValues().isEmpty()).forEach(attrTO -> this.getPlainSchema(attrTO.getSchema()).ifPresent(schema -> {
            PlainAttr attr = any.getPlainAttr(schema.getKey(), relationship).orElseGet(() -> {
                PlainAttr gpa = new PlainAttr();
                gpa.setRelationship(relationship.getKey());
                gpa.setPlainSchema(schema);
                return gpa;
            });
            this.fillAttr((AttributableTO)anyTO, attrTO.getValues(), (PlainSchema)schema, attr, invalidValues);
            if (!attr.getValuesAsStrings().isEmpty()) {
                any.add(attr);
            }
        }));
        if (!invalidValues.isEmpty()) {
            scce.addException(invalidValues);
        }
    }

    protected void membershipPlainAttrsOnCreate(AnyTO anyTO, Groupable<?, ?, ?> any, Membership<?> membership, MembershipTO membershipTO, SyncopeClientCompositeException scce) {
        SyncopeClientException invalidValues = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidValues);
        membershipTO.getPlainAttrs().stream().filter(attrTO -> !attrTO.getValues().isEmpty()).forEach(attrTO -> this.getPlainSchema(attrTO.getSchema()).ifPresent(schema -> {
            PlainAttr attr = any.getPlainAttr(schema.getKey(), membership).orElseGet(() -> {
                PlainAttr gpa = new PlainAttr();
                gpa.setMembership(membership.getKey());
                gpa.setPlainSchema(schema);
                return gpa;
            });
            this.fillAttr((AttributableTO)anyTO, attrTO.getValues(), (PlainSchema)schema, attr, invalidValues);
            if (!attr.getValuesAsStrings().isEmpty()) {
                any.add(attr);
            }
        }));
        if (!invalidValues.isEmpty()) {
            scce.addException(invalidValues);
        }
    }

    protected void relationshipPlainAttrsOnUpdate(Set<Attr> plainAttrs, AnyTO anyTO, Relatable<?, ?> any, Relationship<?, ?> relationship, SyncopeClientCompositeException scce) {
        SyncopeClientException invalidValues = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidValues);
        plainAttrs.forEach(attrTO -> this.getPlainSchema(attrTO.getSchema()).ifPresentOrElse(schema -> any.getPlainAttr(schema.getKey(), relationship).ifPresentOrElse(attr -> LOG.debug("Plain attribute found for {} and relationship {} with {}, nothing to do", new Object[]{schema, relationship.getType().getKey(), relationship.getRightEnd()}), () -> {
            LOG.debug("No plain attribute found for {} and relationship {} with {}", new Object[]{schema, relationship.getType().getKey(), relationship.getRightEnd()});
            PlainAttr newAttr = new PlainAttr();
            newAttr.setRelationship(relationship.getKey());
            newAttr.setPlainSchema(schema);
            any.add(newAttr);
            this.processAttrPatch(anyTO, (Any)any, (AttrPatch)new AttrPatch.Builder(attrTO).build(), (PlainSchema)schema, newAttr, invalidValues);
        }), () -> LOG.debug("Invalid {}{}, ignoring...", (Object)PlainSchema.class.getSimpleName(), (Object)attrTO.getSchema())));
        if (!invalidValues.isEmpty()) {
            scce.addException(invalidValues);
        }
    }

    protected void membershipPlainAttrsOnUpdate(Set<Attr> plainAttrs, AnyTO anyTO, Groupable<?, ?, ?> any, Membership<?> membership, SyncopeClientCompositeException scce) {
        SyncopeClientException invalidValues = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidValues);
        plainAttrs.forEach(attrTO -> this.getPlainSchema(attrTO.getSchema()).ifPresentOrElse(schema -> any.getPlainAttr(schema.getKey(), membership).ifPresentOrElse(attr -> LOG.debug("Plain attribute found for {} and membership of {}, nothing to do", schema, (Object)membership.getRightEnd()), () -> {
            LOG.debug("No plain attribute found for {} and membership of {}", schema, (Object)membership.getRightEnd());
            PlainAttr newAttr = new PlainAttr();
            newAttr.setMembership(membership.getKey());
            newAttr.setPlainSchema(schema);
            any.add(newAttr);
            this.processAttrPatch(anyTO, (Any)any, (AttrPatch)new AttrPatch.Builder(attrTO).build(), (PlainSchema)schema, newAttr, invalidValues);
        }), () -> LOG.debug("Invalid {}{}, ignoring...", (Object)PlainSchema.class.getSimpleName(), (Object)attrTO.getSchema())));
        if (!invalidValues.isEmpty()) {
            scce.addException(invalidValues);
        }
    }

    private static /* synthetic */ void lambda$fill$6(StringPatchItem patch) {
        LOG.debug("Invalid {} {}, ignoring...", (Object)ExternalResource.class.getSimpleName(), patch.getValue());
    }

    private static /* synthetic */ void lambda$fill$5(StringPatchItem patch, Relatable any, ExternalResource resource) {
        switch (patch.getOperation()) {
            case ADD_REPLACE: {
                any.add(resource);
                break;
            }
            default: {
                any.getResources().remove(resource);
            }
        }
    }

    private static /* synthetic */ void lambda$fill$1(StringPatchItem patch) {
        LOG.debug("Invalid {} {}, ignoring...", (Object)AnyTypeClass.class.getSimpleName(), patch.getValue());
    }

    private static /* synthetic */ void lambda$fill$0(StringPatchItem patch, Relatable any, AnyTypeClass auxClass) {
        switch (patch.getOperation()) {
            case ADD_REPLACE: {
                any.add(auxClass);
                break;
            }
            default: {
                any.getAuxClasses().remove(auxClass);
            }
        }
    }
}

