/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.SyncopeClientCompositeException;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.AttributableTO;
import org.apache.syncope.common.lib.to.ConnObject;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.persistence.api.attrvalue.PlainAttrValidationManager;
import org.apache.syncope.core.persistence.api.dao.AnyTypeClassDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.PolicyDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.entity.AnyTemplateRealm;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.api.entity.Attributable;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.policy.AccessPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.AccountPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.AttrReleasePolicy;
import org.apache.syncope.core.persistence.api.entity.policy.AuthPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PasswordPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.TicketExpirationPolicy;
import org.apache.syncope.core.provisioning.api.DerAttrHandler;
import org.apache.syncope.core.provisioning.api.IntAttrName;
import org.apache.syncope.core.provisioning.api.IntAttrNameParser;
import org.apache.syncope.core.provisioning.api.MappingManager;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.data.RealmDataBinder;
import org.apache.syncope.core.provisioning.api.jexl.JexlTools;
import org.apache.syncope.core.provisioning.api.jexl.TemplateUtils;
import org.apache.syncope.core.provisioning.api.rules.PushCorrelationRule;
import org.apache.syncope.core.provisioning.java.data.AttributableDataBinder;
import org.apache.syncope.core.provisioning.java.utils.ConnObjectUtils;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ConnectorObjectBuilder;
import org.identityconnectors.framework.common.objects.Uid;

public class RealmDataBinderImpl
extends AttributableDataBinder
implements RealmDataBinder {
    protected final AnyTypeDAO anyTypeDAO;
    protected final AnyTypeClassDAO anyTypeClassDAO;
    protected final ImplementationDAO implementationDAO;
    protected final RealmDAO realmDAO;
    protected final PolicyDAO policyDAO;
    protected final ExternalResourceDAO resourceDAO;
    protected final EntityFactory entityFactory;
    protected final TemplateUtils templateUtils;

    public RealmDataBinderImpl(AnyTypeDAO anyTypeDAO, AnyTypeClassDAO anyTypeClassDAO, ImplementationDAO implementationDAO, RealmDAO realmDAO, PolicyDAO policyDAO, ExternalResourceDAO resourceDAO, PlainSchemaDAO plainSchemaDAO, EntityFactory entityFactory, DerAttrHandler derAttrHandler, PlainAttrValidationManager validator, MappingManager mappingManager, IntAttrNameParser intAttrNameParser, JexlTools jexlTools, TemplateUtils templateUtils) {
        super(plainSchemaDAO, validator, derAttrHandler, mappingManager, intAttrNameParser, jexlTools);
        this.anyTypeDAO = anyTypeDAO;
        this.anyTypeClassDAO = anyTypeClassDAO;
        this.implementationDAO = implementationDAO;
        this.realmDAO = realmDAO;
        this.policyDAO = policyDAO;
        this.resourceDAO = resourceDAO;
        this.entityFactory = entityFactory;
        this.templateUtils = templateUtils;
    }

    protected SyncopeClientException checkMandatory(Realm realm) {
        SyncopeClientException reqValMissing = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RequiredValuesMissing);
        realm.getAnyTypeClasses().stream().flatMap(atc -> atc.getPlainSchemas().stream()).forEach(schema -> this.checkMandatory((PlainSchema)schema, realm.getPlainAttr(schema.getKey()).orElse(null), (Attributable)realm, reqValMissing));
        return reqValMissing;
    }

    protected void fill(RealmTO realmTO, Realm realm, SyncopeClientCompositeException scce) {
        SyncopeClientException requiredValuesMissing;
        realm.getPlainAttrs().forEach(arg_0 -> ((Realm)realm).remove(arg_0));
        SyncopeClientException invalidValues = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidValues);
        realmTO.getPlainAttrs().stream().filter(attrTO -> !attrTO.getValues().isEmpty()).forEach(attrTO -> this.getPlainSchema(attrTO.getSchema()).ifPresent(schema -> {
            PlainAttr attr = realm.getPlainAttr(schema.getKey()).orElseGet(() -> {
                PlainAttr newAttr = new PlainAttr();
                newAttr.setPlainSchema(schema);
                return newAttr;
            });
            this.fillAttr((AttributableTO)realmTO, attrTO.getValues(), (PlainSchema)schema, attr, invalidValues);
            if (!attr.getValuesAsStrings().isEmpty()) {
                realm.add(attr);
            }
        }));
        if (!invalidValues.isEmpty()) {
            scce.addException(invalidValues);
        }
        if (!(requiredValuesMissing = this.checkMandatory(realm)).isEmpty()) {
            scce.addException(requiredValuesMissing);
        }
    }

    protected void bind(Realm realm, RealmTO realmTO, SyncopeClientCompositeException scce) {
        realm.setName(realmTO.getName());
        realmTO.getAnyTypeClasses().forEach(anyTypeClass -> this.anyTypeClassDAO.findById(anyTypeClass).ifPresentOrElse(arg_0 -> ((Realm)realm).add(arg_0), () -> LOG.debug("Invalid {} {}, ignoring...", (Object)AnyTypeClass.class.getSimpleName(), anyTypeClass)));
        realm.getAnyTypeClasses().removeIf(c -> c == null || !realmTO.getAnyTypeClasses().contains(c.getKey()));
        this.fill(realmTO, realm, scce);
        realm.setAccessPolicy((AccessPolicy)Optional.ofNullable(realmTO.getAccessPolicy()).flatMap(p -> this.policyDAO.findById(p, AccessPolicy.class)).orElse(null));
        realm.setAccountPolicy((AccountPolicy)Optional.ofNullable(realmTO.getAccountPolicy()).flatMap(p -> this.policyDAO.findById(p, AccountPolicy.class)).orElse(null));
        realm.setAttrReleasePolicy((AttrReleasePolicy)Optional.ofNullable(realmTO.getAttrReleasePolicy()).flatMap(p -> this.policyDAO.findById(p, AttrReleasePolicy.class)).orElse(null));
        realm.setAuthPolicy((AuthPolicy)Optional.ofNullable(realmTO.getAuthPolicy()).flatMap(p -> this.policyDAO.findById(p, AuthPolicy.class)).orElse(null));
        realm.setPasswordPolicy((PasswordPolicy)Optional.ofNullable(realmTO.getPasswordPolicy()).flatMap(p -> this.policyDAO.findById(p, PasswordPolicy.class)).orElse(null));
        realm.setTicketExpirationPolicy((TicketExpirationPolicy)Optional.ofNullable(realmTO.getTicketExpirationPolicy()).flatMap(p -> this.policyDAO.findById(p, TicketExpirationPolicy.class)).orElse(null));
        realmTO.getActions().forEach(key -> this.implementationDAO.findById(key).ifPresentOrElse(arg_0 -> ((Realm)realm).add(arg_0), () -> LOG.debug("Invalid {} {}, ignoring...", (Object)Implementation.class.getSimpleName(), key)));
        realm.getActions().removeIf(implementation -> !realmTO.getActions().contains(implementation.getKey()));
        this.templateUtils.check(realmTO.getTemplates(), ClientExceptionType.InvalidRealm);
        realmTO.getTemplates().forEach((key, template) -> this.anyTypeDAO.findById(key).ifPresentOrElse(type -> {
            AnyTemplateRealm anyTemplate = realm.getTemplate(type).orElse(null);
            if (anyTemplate == null) {
                anyTemplate = (AnyTemplateRealm)this.entityFactory.newEntity(AnyTemplateRealm.class);
                anyTemplate.setAnyType(type);
                anyTemplate.setRealm(realm);
                realm.add(anyTemplate);
            }
            anyTemplate.set(template);
        }, () -> LOG.debug("Invalid AnyType {} specified, ignoring...", key)));
        realm.getTemplates().removeIf(template -> !realmTO.getTemplates().containsKey(template.getAnyType().getKey()));
        if (scce.hasExceptions()) {
            throw scce;
        }
    }

    protected List<String> evaluateMandatoryCondition(ExternalResource resource, Realm realm) {
        if (resource.getOrgUnit() == null) {
            return List.of();
        }
        ArrayList<String> missingAttrNames = new ArrayList<String>();
        MappingUtils.getPropagationItems(resource.getOrgUnit().getItems().stream()).forEach(item -> {
            AttrSchemaType schemaType;
            MappingManager.IntValues intValues;
            IntAttrName intAttrName = null;
            try {
                intAttrName = this.intAttrNameParser.parse(item.getIntAttrName());
            }
            catch (ParseException e) {
                LOG.error("Invalid intAttrName '{}', ignoring", (Object)item.getIntAttrName(), (Object)e);
            }
            if (intAttrName != null && intAttrName.getSchemaInfo() != null && (intValues = this.mappingManager.getIntValues(resource, item, intAttrName, schemaType = intAttrName.getSchemaInfo().schema() instanceof PlainSchema ? intAttrName.getSchemaInfo().schema().getType() : AttrSchemaType.String, realm)).values().isEmpty() && this.jexlTools.evaluateMandatoryCondition(item.getMandatoryCondition(), (Attributable)realm, this.derAttrHandler)) {
                missingAttrNames.add(item.getIntAttrName());
            }
        });
        return missingAttrNames;
    }

    protected SyncopeClientException checkMandatoryOnResources(Realm realm) {
        SyncopeClientException reqValMissing = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RequiredValuesMissing);
        realm.getResources().stream().filter(ExternalResource::isEnforceMandatoryCondition).forEach(resource -> {
            List<String> missingAttrNames = this.evaluateMandatoryCondition((ExternalResource)resource, realm);
            if (!missingAttrNames.isEmpty()) {
                LOG.error("Mandatory schemas {} not provided with values", missingAttrNames);
                reqValMissing.getElements().addAll(missingAttrNames);
            }
        });
        return reqValMissing;
    }

    public Realm create(Realm parent, RealmTO realmTO) {
        Realm realm = (Realm)this.entityFactory.newEntity(Realm.class);
        realm.setParent(parent);
        SyncopeClientCompositeException scce = SyncopeClientException.buildComposite();
        this.bind(realm, realmTO, scce);
        realmTO.getResources().forEach(key -> this.resourceDAO.findById(key).ifPresentOrElse(arg_0 -> ((Realm)realm).add(arg_0), () -> LOG.debug("Invalid {} {}, ignoring...", (Object)ExternalResource.class.getSimpleName(), key)));
        SyncopeClientException requiredValuesMissing = this.checkMandatoryOnResources(realm);
        if (!requiredValuesMissing.isEmpty()) {
            scce.addException(requiredValuesMissing);
        }
        return realm;
    }

    protected Map<String, ConnObject> onResources(Realm realm) {
        HashMap<String, ConnObject> onResources = new HashMap<String, ConnObject>();
        realm.getResources().forEach(resource -> Optional.ofNullable(resource.getOrgUnit()).ifPresent(orgUnit -> orgUnit.getConnObjectKeyItem().ifPresent(keyItem -> {
            ConnObject connObjectTO;
            MappingManager.PreparedAttrs prepared = this.mappingManager.prepareAttrsFromRealm(realm, resource);
            if (StringUtils.isBlank((CharSequence)prepared.connObjectLink())) {
                connObjectTO = ConnObjectUtils.getConnObjectTO(null, prepared.attributes());
            } else {
                ConnectorObject connectorObject = new ConnectorObjectBuilder().addAttributes((Collection)prepared.attributes()).addAttribute(new Attribute[]{new Uid(prepared.connObjectLink())}).addAttribute(new Attribute[]{AttributeBuilder.build((String)keyItem.getExtAttrName(), (Object[])new Object[]{prepared.connObjectLink()})}).build();
                connObjectTO = ConnObjectUtils.getConnObjectTO((String)PushCorrelationRule.DEFAULT_FIQL_BUILDER.apply(connectorObject), connectorObject.getAttributes());
            }
            onResources.put(resource.getKey(), connObjectTO);
        })));
        return onResources;
    }

    public PropagationByResource<String> update(Realm realm, RealmTO realmTO) {
        Map<String, ConnObject> beforeOnResources = this.onResources(realm);
        realm.setParent((Realm)Optional.ofNullable(realmTO.getParent()).flatMap(arg_0 -> ((RealmDAO)this.realmDAO).findById(arg_0)).orElse(null));
        SyncopeClientCompositeException scce = SyncopeClientException.buildComposite();
        this.bind(realm, realmTO, scce);
        realmTO.getResources().forEach(key -> this.resourceDAO.findById(key).ifPresentOrElse(arg_0 -> ((Realm)realm).add(arg_0), () -> LOG.debug("Invalid {} {}, ignoring...", (Object)ExternalResource.class.getSimpleName(), key)));
        realm.getResources().removeIf(resource -> !realmTO.getResources().contains(resource.getKey()));
        SyncopeClientException requiredValuesMissing = this.checkMandatoryOnResources(realm);
        if (!requiredValuesMissing.isEmpty()) {
            scce.addException(requiredValuesMissing);
        }
        return this.propByRes(beforeOnResources, this.onResources(realm));
    }

    public RealmTO getRealmTO(Realm realm, boolean admin) {
        RealmTO realmTO = new RealmTO();
        realmTO.setKey(realm.getKey());
        realmTO.setName(realm.getName());
        Optional.ofNullable(realm.getParent()).ifPresent(parent -> realmTO.setParent(parent.getKey()));
        realmTO.setFullPath(realm.getFullPath());
        realmTO.getAnyTypeClasses().addAll(realm.getAnyTypeClasses().stream().map(Entity::getKey).toList());
        realm.getPlainAttrs().forEach(plainAttr -> realmTO.getPlainAttrs().add(new Attr.Builder(plainAttr.getSchema()).values((Collection)plainAttr.getValuesAsStrings()).build()));
        this.derAttrHandler.getValues(realm).forEach((schema, value) -> realmTO.getDerAttrs().add(new Attr.Builder(schema).value(value).build()));
        if (admin) {
            Optional.ofNullable(realm.getAccountPolicy()).map(Entity::getKey).ifPresent(arg_0 -> ((RealmTO)realmTO).setAccountPolicy(arg_0));
            Optional.ofNullable(realm.getPasswordPolicy()).map(Entity::getKey).ifPresent(arg_0 -> ((RealmTO)realmTO).setPasswordPolicy(arg_0));
            Optional.ofNullable(realm.getAuthPolicy()).map(Entity::getKey).ifPresent(arg_0 -> ((RealmTO)realmTO).setAuthPolicy(arg_0));
            Optional.ofNullable(realm.getAccessPolicy()).map(Entity::getKey).ifPresent(arg_0 -> ((RealmTO)realmTO).setAccessPolicy(arg_0));
            Optional.ofNullable(realm.getAttrReleasePolicy()).map(Entity::getKey).ifPresent(arg_0 -> ((RealmTO)realmTO).setAttrReleasePolicy(arg_0));
            Optional.ofNullable(realm.getTicketExpirationPolicy()).map(Entity::getKey).ifPresent(arg_0 -> ((RealmTO)realmTO).setTicketExpirationPolicy(arg_0));
            realmTO.getActions().addAll(realm.getActions().stream().map(Entity::getKey).toList());
            realm.getTemplates().forEach(template -> realmTO.getTemplates().put(template.getAnyType().getKey(), template.get()));
            realmTO.getResources().addAll(realm.getResources().stream().map(Entity::getKey).toList());
        }
        return realmTO;
    }
}

