/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Supplier;
import org.apache.syncope.core.persistence.api.entity.task.ProvisioningTask;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningActions;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningProfile;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopeResultHandler;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.SyncopeAuthenticationDetails;
import org.apache.syncope.core.spring.task.VirtualThreadPoolTaskExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;

public abstract class SyncopeResultHandlerDispatcher<T extends ProvisioningTask<?>, A extends ProvisioningActions, RA extends SyncopeResultHandler<T, A>> {
    protected static final Logger LOG = LoggerFactory.getLogger(SyncopeResultHandlerDispatcher.class);
    private static final String PLACEHOLDER_PWD = "PLACEHOLDER_PWD";
    protected Optional<VirtualThreadPoolTaskExecutor> tpte;
    protected final Map<String, Supplier<RA>> suppliers = new ConcurrentHashMap<String, Supplier<RA>>();
    protected final Map<String, RA> handlers = new ConcurrentHashMap<String, RA>();
    protected final List<Future<?>> futures = new ArrayList();

    protected void init(ProvisioningProfile<T, A> profile) {
        if (profile.getTask().getConcurrentSettings() == null) {
            this.tpte = Optional.empty();
        } else {
            VirtualThreadPoolTaskExecutor t = new VirtualThreadPoolTaskExecutor();
            t.setPoolSize(profile.getTask().getConcurrentSettings().getPoolSize());
            t.setWaitForTasksToCompleteOnShutdown(true);
            t.setThreadNamePrefix("provisioningTask-" + profile.getTask().getKey() + "-");
            t.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy());
            String domain = AuthContextUtils.getDomain();
            String delegatedBy = AuthContextUtils.getDelegatedBy().orElse(null);
            Set authorities = AuthContextUtils.getAuthorities();
            t.setTaskDecorator(d -> () -> {
                UsernamePasswordAuthenticationToken placeHolderAuth = new UsernamePasswordAuthenticationToken((Object)new User(profile.getExecutor(), PLACEHOLDER_PWD, (Collection)authorities), (Object)PLACEHOLDER_PWD, (Collection)authorities);
                placeHolderAuth.setDetails((Object)new SyncopeAuthenticationDetails(domain, delegatedBy));
                SecurityContextHolder.getContext().setAuthentication((Authentication)placeHolderAuth);
                d.run();
            });
            t.initialize();
            this.tpte = Optional.of(t);
        }
    }

    public void addHandlerSupplier(String key, Supplier<RA> supplier) {
        this.suppliers.put(key, supplier);
    }

    public RA nonConcurrentHandler(String key) {
        return (RA)this.handlers.computeIfAbsent(key, k -> (SyncopeResultHandler)this.suppliers.get(k).get());
    }

    protected void submit(Runnable runnable) {
        this.tpte.ifPresent(executor -> this.futures.add(executor.submit(runnable)));
    }

    public void stop() {
        this.handlers.values().forEach(SyncopeResultHandler::stop);
    }

    protected void shutdown() {
        for (Future<?> f : this.futures) {
            try {
                f.get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.error("Unexpected error when waiting for completion", (Throwable)e);
            }
        }
        this.tpte.ifPresent(VirtualThreadPoolTaskExecutor::shutdown);
    }
}

