/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.crypto;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import java.security.Key;
import org.apereo.cas.util.NamedObject;
import org.apereo.cas.util.crypto.DecodableCipher;
import org.apereo.cas.util.crypto.EncodableCipher;
import org.apereo.cas.util.crypto.NoOpCipherExecutor;

public interface CipherExecutor<I, O>
extends EncodableCipher<I, O>,
DecodableCipher<I, O>,
NamedObject {
    public static final String BEAN_NAME_TICKET_REGISTRY_CIPHER_EXECUTOR = "defaultTicketRegistryCipherExecutor";
    public static final String BEAN_NAME_CAS_CONFIGURATION_CIPHER_EXECUTOR = "casConfigurationCipherExecutor";
    public static final String BEAN_NAME_WEBFLOW_CIPHER_EXECUTOR = "webflowCipherExecutor";
    public static final String BEAN_NAME_TGC_CIPHER_EXECUTOR = "cookieCipherExecutor";

    public static CipherExecutor<Serializable, Serializable> noOp() {
        return NoOpCipherExecutor.INSTANCE;
    }

    public static CipherExecutor<String, String> noOpOfStringToString() {
        return NoOpCipherExecutor.INSTANCE;
    }

    public static CipherExecutor<Number, Number> noOpOfNumberToNumber() {
        return NoOpCipherExecutor.INSTANCE;
    }

    public static CipherExecutor<Serializable, String> noOpOfSerializableToString() {
        return NoOpCipherExecutor.INSTANCE;
    }

    default public boolean isEnabled() {
        return true;
    }

    default public Key getSigningKey() {
        return null;
    }

    @CanIgnoreReturnValue
    default public CipherExecutor<I, ?> withSigningDisabled() {
        return this;
    }
}

