/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.support;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.model.support.cookie.CookieProperties;
import org.apereo.cas.web.support.CookieUtils;
import org.springframework.web.servlet.ThemeResolver;
import org.springframework.web.util.WebUtils;

public class CookieThemeResolver
implements ThemeResolver {
    public static final String ORIGINAL_DEFAULT_THEME_NAME = "theme";
    public static final String THEME_REQUEST_ATTRIBUTE_NAME = CookieThemeResolver.class.getName() + ".THEME";
    public static final String DEFAULT_COOKIE_NAME = CookieThemeResolver.class.getName() + ".THEME";
    private String defaultThemeName = "theme";
    private final CookieProperties cookieProperties;

    public String resolveThemeName(HttpServletRequest request) {
        String value;
        String themeName = (String)request.getAttribute(THEME_REQUEST_ATTRIBUTE_NAME);
        if (StringUtils.isNotBlank((CharSequence)themeName)) {
            return themeName;
        }
        Cookie cookie = WebUtils.getCookie((HttpServletRequest)request, (String)DEFAULT_COOKIE_NAME);
        if (cookie != null && StringUtils.isNotBlank((CharSequence)(value = cookie.getValue()))) {
            themeName = value;
        }
        if (StringUtils.isBlank((CharSequence)themeName)) {
            themeName = this.getDefaultThemeName();
        }
        request.setAttribute(THEME_REQUEST_ATTRIBUTE_NAME, (Object)themeName);
        return themeName;
    }

    public void setThemeName(HttpServletRequest request, HttpServletResponse response, String themeName) {
        Objects.requireNonNull(this.cookieProperties, "CookieProperties must not be null");
        if (StringUtils.isNotBlank((CharSequence)themeName)) {
            request.setAttribute(THEME_REQUEST_ATTRIBUTE_NAME, (Object)themeName);
            String cookie = CookieUtils.createSetCookieHeader(themeName, this.cookieProperties.withName(DEFAULT_COOKIE_NAME));
            response.addHeader("Set-Cookie", cookie);
        } else {
            request.setAttribute(THEME_REQUEST_ATTRIBUTE_NAME, (Object)this.getDefaultThemeName());
            String cookie = CookieUtils.createSetCookieHeader("", this.cookieProperties.withName(DEFAULT_COOKIE_NAME).withMaxAge("0"));
            response.addHeader("Set-Cookie", cookie);
        }
    }

    @Generated
    public CookieThemeResolver(CookieProperties cookieProperties) {
        this.cookieProperties = cookieProperties;
    }

    @Generated
    public void setDefaultThemeName(String defaultThemeName) {
        this.defaultThemeName = defaultThemeName;
    }

    @Generated
    public String getDefaultThemeName() {
        return this.defaultThemeName;
    }
}

