/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.service;

import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.cxf.jaxrs.ext.search.SearchBean;
import org.apache.cxf.jaxrs.ext.search.SearchCondition;
import org.apache.cxf.jaxrs.ext.search.SearchConditionVisitor;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.search.SearchCondVisitor;
import org.apache.syncope.core.rest.cxf.service.AbstractService;

public abstract class AbstractSearchService
extends AbstractService {
    protected final SearchCondVisitor searchCondVisitor;

    public AbstractSearchService(SearchCondVisitor searchCondVisitor) {
        this.searchCondVisitor = searchCondVisitor;
    }

    protected SearchCond getSearchCond(String fiql, String realm) {
        try {
            this.searchCondVisitor.setRealm(realm);
            SearchCondition sc = this.searchContext.getCondition(fiql, SearchBean.class);
            sc.accept((SearchConditionVisitor)this.searchCondVisitor);
            return this.searchCondVisitor.getQuery();
        }
        catch (Exception e) {
            LOG.error("Invalid FIQL expression: {}", (Object)fiql, (Object)e);
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidSearchParameters);
            sce.getElements().add(fiql);
            sce.getElements().add(ExceptionUtils.getRootCauseMessage((Throwable)e));
            throw sce;
        }
    }
}

