/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.notifications.call;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.apereo.cas.configuration.model.support.phone.PhoneProperties;
import org.apereo.cas.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.AbstractResource;

public class PhoneCallBodyBuilder
implements Supplier<String> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(PhoneCallBodyBuilder.class);
    @NonNull
    private final PhoneProperties properties;
    private final Map<String, Object> parameters;

    @Override
    public String get() {
        String string;
        block9: {
            if (StringUtils.isBlank((CharSequence)this.properties.getText())) {
                LOGGER.warn("No phone call text is defined");
                return "";
            }
            AbstractResource templateFile = ResourceUtils.getResourceFrom((String)this.properties.getText());
            InputStream is = templateFile.getInputStream();
            try {
                String contents = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                string = this.formatBody(contents);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    LOGGER.trace(e.getMessage(), e);
                    return this.formatBody(this.properties.getText());
                }
            }
            is.close();
        }
        return string;
    }

    protected String formatBody(String contents) {
        StringSubstitutor sub = new StringSubstitutor(this.parameters, "${", "}");
        return sub.replace(contents);
    }

    @Generated
    private static Map<String, Object> $default$parameters() {
        return new LinkedHashMap<String, Object>();
    }

    @Generated
    protected PhoneCallBodyBuilder(PhoneCallBodyBuilderBuilder<?, ?> b) {
        this.properties = b.properties;
        if (this.properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.parameters = b.parameters$set ? b.parameters$value : PhoneCallBodyBuilder.$default$parameters();
    }

    @Generated
    public static PhoneCallBodyBuilderBuilder<?, ?> builder() {
        return new PhoneCallBodyBuilderBuilderImpl();
    }

    @Generated
    public static abstract class PhoneCallBodyBuilderBuilder<C extends PhoneCallBodyBuilder, B extends PhoneCallBodyBuilderBuilder<C, B>> {
        @Generated
        private PhoneProperties properties;
        @Generated
        private boolean parameters$set;
        @Generated
        private Map<String, Object> parameters$value;

        @Generated
        public B properties(@NonNull PhoneProperties properties) {
            if (properties == null) {
                throw new NullPointerException("properties is marked non-null but is null");
            }
            this.properties = properties;
            return this.self();
        }

        @Generated
        public B parameters(Map<String, Object> parameters) {
            this.parameters$value = parameters;
            this.parameters$set = true;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "PhoneCallBodyBuilder.PhoneCallBodyBuilderBuilder(properties=" + String.valueOf(this.properties) + ", parameters$value=" + String.valueOf(this.parameters$value) + ")";
        }
    }

    @Generated
    private static final class PhoneCallBodyBuilderBuilderImpl
    extends PhoneCallBodyBuilderBuilder<PhoneCallBodyBuilder, PhoneCallBodyBuilderBuilderImpl> {
        @Generated
        private PhoneCallBodyBuilderBuilderImpl() {
        }

        @Override
        @Generated
        protected PhoneCallBodyBuilderBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public PhoneCallBodyBuilder build() {
            return new PhoneCallBodyBuilder(this);
        }
    }
}

