/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.LDAPSDKException;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotExtensible
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public class LDAPException
extends LDAPSDKException {
    private static final long serialVersionUID = -4257171063946350327L;
    @NotNull
    protected static final Control[] NO_CONTROLS = StaticUtils.NO_CONTROLS;
    @NotNull
    protected static final String[] NO_REFERRALS = StaticUtils.NO_STRINGS;
    @NotNull
    private final Control[] responseControls;
    @NotNull
    private final ResultCode resultCode;
    @NotNull
    private final String[] referralURLs;
    @Nullable
    private final String diagnosticMessage;
    @Nullable
    private final String matchedDN;

    public LDAPException(@NotNull ResultCode resultCode) {
        super(resultCode.getName());
        this.resultCode = resultCode;
        this.matchedDN = null;
        this.diagnosticMessage = null;
        this.referralURLs = NO_REFERRALS;
        this.responseControls = NO_CONTROLS;
    }

    public LDAPException(@NotNull ResultCode resultCode, @Nullable Throwable cause) {
        super(resultCode.getName(), cause);
        this.resultCode = resultCode;
        this.matchedDN = null;
        this.diagnosticMessage = null;
        this.referralURLs = NO_REFERRALS;
        this.responseControls = NO_CONTROLS;
    }

    public LDAPException(@NotNull ResultCode resultCode, @NotNull String errorMessage) {
        super(errorMessage);
        this.resultCode = resultCode;
        this.matchedDN = null;
        this.diagnosticMessage = null;
        this.referralURLs = NO_REFERRALS;
        this.responseControls = NO_CONTROLS;
    }

    public LDAPException(@NotNull ResultCode resultCode, @NotNull String errorMessage, @Nullable Throwable cause) {
        super(errorMessage, cause);
        this.resultCode = resultCode;
        this.matchedDN = null;
        this.diagnosticMessage = null;
        this.referralURLs = NO_REFERRALS;
        this.responseControls = NO_CONTROLS;
    }

    public LDAPException(@NotNull ResultCode resultCode, @NotNull String errorMessage, @Nullable String matchedDN, @Nullable String[] referralURLs) {
        super(errorMessage);
        this.resultCode = resultCode;
        this.matchedDN = matchedDN;
        this.referralURLs = referralURLs == null ? NO_REFERRALS : referralURLs;
        this.diagnosticMessage = null;
        this.responseControls = NO_CONTROLS;
    }

    public LDAPException(@NotNull ResultCode resultCode, @NotNull String errorMessage, @Nullable String matchedDN, @Nullable String[] referralURLs, @Nullable Throwable cause) {
        super(errorMessage, cause);
        this.resultCode = resultCode;
        this.matchedDN = matchedDN;
        this.referralURLs = referralURLs == null ? NO_REFERRALS : referralURLs;
        this.diagnosticMessage = null;
        this.responseControls = NO_CONTROLS;
    }

    public LDAPException(@NotNull ResultCode resultCode, @NotNull String errorMessage, @Nullable String matchedDN, @Nullable String[] referralURLs, @Nullable Control[] controls) {
        super(errorMessage);
        this.resultCode = resultCode;
        this.matchedDN = matchedDN;
        this.diagnosticMessage = null;
        this.referralURLs = referralURLs == null ? NO_REFERRALS : referralURLs;
        this.responseControls = controls == null ? NO_CONTROLS : controls;
    }

    public LDAPException(@NotNull ResultCode resultCode, @NotNull String errorMessage, @Nullable String matchedDN, @Nullable String[] referralURLs, @Nullable Control[] controls, @Nullable Throwable cause) {
        super(errorMessage, cause);
        this.resultCode = resultCode;
        this.matchedDN = matchedDN;
        this.diagnosticMessage = null;
        this.referralURLs = referralURLs == null ? NO_REFERRALS : referralURLs;
        this.responseControls = controls == null ? NO_CONTROLS : controls;
    }

    public LDAPException(@NotNull LDAPResult ldapResult) {
        super(ldapResult.getDiagnosticMessage() == null ? ldapResult.getResultCode().getName() : ldapResult.getDiagnosticMessage());
        this.resultCode = ldapResult.getResultCode();
        this.matchedDN = ldapResult.getMatchedDN();
        this.diagnosticMessage = ldapResult.getDiagnosticMessage();
        this.referralURLs = ldapResult.getReferralURLs();
        this.responseControls = ldapResult.getResponseControls();
    }

    public LDAPException(@NotNull LDAPResult ldapResult, @Nullable Throwable cause) {
        super(ldapResult.getDiagnosticMessage() == null ? ldapResult.getResultCode().getName() : ldapResult.getDiagnosticMessage(), cause);
        this.resultCode = ldapResult.getResultCode();
        this.matchedDN = ldapResult.getMatchedDN();
        this.diagnosticMessage = ldapResult.getDiagnosticMessage();
        this.referralURLs = ldapResult.getReferralURLs();
        this.responseControls = ldapResult.getResponseControls();
    }

    public LDAPException(@NotNull LDAPException e) {
        super(e.getMessage(), e.getCause());
        this.resultCode = e.getResultCode();
        this.matchedDN = e.getMatchedDN();
        this.diagnosticMessage = e.getDiagnosticMessage();
        this.referralURLs = e.getReferralURLs();
        this.responseControls = e.getResponseControls();
    }

    @NotNull
    public final ResultCode getResultCode() {
        return this.resultCode;
    }

    @Nullable
    public final String getMatchedDN() {
        return this.matchedDN;
    }

    @Nullable
    public final String getDiagnosticMessage() {
        return this.diagnosticMessage;
    }

    @NotNull
    public final String[] getReferralURLs() {
        return this.referralURLs;
    }

    public final boolean hasResponseControl() {
        return this.responseControls.length > 0;
    }

    public final boolean hasResponseControl(@NotNull String oid) {
        for (Control c : this.responseControls) {
            if (!c.getOID().equals(oid)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public final Control[] getResponseControls() {
        return this.responseControls;
    }

    @Nullable
    public final Control getResponseControl(@NotNull String oid) {
        for (Control c : this.responseControls) {
            if (!c.getOID().equals(oid)) continue;
            return c;
        }
        return null;
    }

    @NotNull
    public LDAPResult toLDAPResult() {
        if (this.diagnosticMessage == null && this.getMessage() != null) {
            return new LDAPResult(-1, this.resultCode, this.getMessage(), this.matchedDN, this.referralURLs, this.responseControls);
        }
        return new LDAPResult(-1, this.resultCode, this.diagnosticMessage, this.matchedDN, this.referralURLs, this.responseControls);
    }

    @NotNull
    public String getResultString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("result code='");
        buffer.append(this.resultCode);
        buffer.append('\'');
        if (this.diagnosticMessage != null && !this.diagnosticMessage.isEmpty()) {
            buffer.append(" diagnostic message='");
            buffer.append(this.diagnosticMessage);
            buffer.append('\'');
        }
        if (this.matchedDN != null && !this.matchedDN.isEmpty()) {
            buffer.append("  matched DN='");
            buffer.append(this.matchedDN);
            buffer.append('\'');
        }
        if (this.referralURLs != null && this.referralURLs.length > 0) {
            buffer.append("  referral URLs={");
            for (int i = 0; i < this.referralURLs.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append('\'');
                buffer.append(this.referralURLs[i]);
                buffer.append('\'');
            }
            buffer.append('}');
        }
        return buffer.toString();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        boolean includeCause = Boolean.getBoolean("com.unboundid.ldap.sdk.debug.includeCauseInExceptionMessages");
        boolean includeStackTrace = Boolean.getBoolean("com.unboundid.ldap.sdk.debug.includeStackTraceInExceptionMessages");
        this.toString(buffer, includeCause, includeStackTrace);
    }

    public void toString(@NotNull StringBuilder buffer, boolean includeCause, boolean includeStackTrace) {
        Throwable cause;
        int i;
        buffer.append("LDAPException(resultCode=");
        buffer.append(this.resultCode);
        String errorMessage = this.getMessage();
        if (errorMessage != null && !errorMessage.equals(this.diagnosticMessage)) {
            buffer.append(", errorMessage='");
            buffer.append(errorMessage);
            buffer.append('\'');
        }
        if (this.diagnosticMessage != null) {
            buffer.append(", diagnosticMessage='");
            buffer.append(this.diagnosticMessage);
            buffer.append('\'');
        }
        if (this.matchedDN != null) {
            buffer.append(", matchedDN='");
            buffer.append(this.matchedDN);
            buffer.append('\'');
        }
        if (this.referralURLs.length > 0) {
            buffer.append(", referralURLs={");
            for (i = 0; i < this.referralURLs.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append('\'');
                buffer.append(this.referralURLs[i]);
                buffer.append('\'');
            }
            buffer.append('}');
        }
        if (this.responseControls.length > 0) {
            buffer.append(", responseControls={");
            for (i = 0; i < this.responseControls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(this.responseControls[i]);
            }
            buffer.append('}');
        }
        if (includeStackTrace) {
            buffer.append(", trace='");
            StaticUtils.getStackTrace(this.getStackTrace(), buffer);
            buffer.append('\'');
        }
        if ((includeCause || includeStackTrace) && (cause = this.getCause()) != null) {
            buffer.append(", cause=");
            buffer.append(StaticUtils.getExceptionMessage(cause, true, includeStackTrace));
        }
        String ldapSDKVersionString = ", ldapSDKVersion=7.0.4, revision=2b16a372bacd6513a5fc43f479dd54bdf0bdf27a";
        if (buffer.indexOf(", ldapSDKVersion=7.0.4, revision=2b16a372bacd6513a5fc43f479dd54bdf0bdf27a") < 0) {
            buffer.append(", ldapSDKVersion=7.0.4, revision=2b16a372bacd6513a5fc43f479dd54bdf0bdf27a");
        }
        buffer.append(')');
    }

    @Override
    @NotNull
    public final String getExceptionMessage() {
        return this.toString();
    }

    @Override
    @NotNull
    public final String getExceptionMessage(boolean includeCause, boolean includeStackTrace) {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer, includeCause, includeStackTrace);
        return buffer.toString();
    }
}

