/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.jdbc;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.Collection;
import lombok.Generated;
import org.apereo.cas.pm.PasswordChangeRequest;
import org.apereo.cas.pm.impl.history.BasePasswordHistoryService;
import org.apereo.cas.pm.impl.history.PasswordHistoryEntity;
import org.apereo.cas.pm.jdbc.JdbcPasswordHistoryEntity;
import org.springframework.transaction.annotation.Transactional;

@Transactional(transactionManager="transactionManagerPasswordHistory")
public class JdbcPasswordHistoryService
extends BasePasswordHistoryService {
    private static final String SELECT_QUERY = "SELECT p FROM JdbcPasswordHistoryEntity p ";
    @PersistenceContext(unitName="jpaPasswordHistoryContext")
    private EntityManager entityManager;

    public boolean exists(PasswordChangeRequest changeRequest) {
        String encodedPassword = this.encodePassword(changeRequest.toPassword());
        String query = SELECT_QUERY.concat("WHERE p.username = :username AND p.password = :password");
        return !this.entityManager.createQuery(query, JdbcPasswordHistoryEntity.class).setParameter("username", (Object)changeRequest.getUsername()).setParameter("password", (Object)encodedPassword).setMaxResults(1).getResultList().isEmpty();
    }

    public boolean store(PasswordChangeRequest changeRequest) {
        String encodedPassword = this.encodePassword(changeRequest.toPassword());
        JdbcPasswordHistoryEntity entity = new JdbcPasswordHistoryEntity();
        entity.setUsername(changeRequest.getUsername());
        entity.setPassword(encodedPassword);
        this.entityManager.merge((Object)entity);
        return true;
    }

    public Collection<? extends PasswordHistoryEntity> fetchAll() {
        return this.entityManager.createQuery(SELECT_QUERY, JdbcPasswordHistoryEntity.class).getResultList();
    }

    public Collection<? extends PasswordHistoryEntity> fetch(String username) {
        return this.entityManager.createQuery(SELECT_QUERY.concat("WHERE p.username = :username"), JdbcPasswordHistoryEntity.class).setParameter("username", (Object)username).getResultList();
    }

    public void remove(String username) {
        this.entityManager.createQuery("DELETE FROM JdbcPasswordHistoryEntity p WHERE p.username = :username").setParameter("username", (Object)username).executeUpdate();
    }

    public void removeAll() {
        this.entityManager.createQuery("DELETE FROM JdbcPasswordHistoryEntity p").executeUpdate();
    }

    @Generated
    public String toString() {
        return "JdbcPasswordHistoryService(entityManager=" + String.valueOf(this.entityManager) + ")";
    }

    @Generated
    public EntityManager getEntityManager() {
        return this.entityManager;
    }
}

