/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.to;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.syncope.common.lib.to.Item;

public abstract class ItemContainer
implements Serializable {
    private static final long serialVersionUID = 3637981417797873343L;
    private final List<Item> items = new ArrayList<Item>();

    @JsonIgnore
    public Optional<Item> getConnObjectKeyItem() {
        return this.getItems().stream().filter(Item::isConnObjectKey).findFirst();
    }

    protected boolean addConnObjectKeyItem(Item connObjectItem) {
        connObjectItem.setMandatoryCondition("true");
        connObjectItem.setConnObjectKey(true);
        return this.add(connObjectItem);
    }

    public boolean setConnObjectKeyItem(Item connObjectKeyItem) {
        return Optional.ofNullable(connObjectKeyItem).map(this::addConnObjectKeyItem).orElseGet(() -> this.getConnObjectKeyItem().map(this.items::remove).orElse(false));
    }

    public List<Item> getItems() {
        return this.items;
    }

    public boolean add(Item item) {
        return Optional.ofNullable(item).filter(itemTO -> this.items.contains(itemTO) || this.items.add((Item)itemTO)).isPresent();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ItemContainer other = (ItemContainer)obj;
        return new EqualsBuilder().append(this.items, other.items).build();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.items).build();
    }
}

