/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.pages;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.pages.BaseExtPage;
import org.apache.syncope.client.enduser.panels.UserRequestDetails;
import org.apache.syncope.client.enduser.rest.BpmnProcessRestClient;
import org.apache.syncope.client.enduser.rest.UserRequestRestClient;
import org.apache.syncope.client.ui.commons.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.client.ui.commons.annotations.ExtPage;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.ui.commons.wicket.markup.html.bootstrap.tabs.Accordion;
import org.apache.syncope.common.lib.to.BpmnProcess;
import org.apache.syncope.common.lib.to.UserRequest;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.navigation.paging.AjaxPagingNavigator;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.extensions.markup.html.tabs.AbstractTab;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.navigation.paging.IPageable;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.spring.injection.annot.SpringBean;

@ExtPage(label="Flowable", icon="fa fa-briefcase", listEntitlement="")
public class Flowable
extends BaseExtPage {
    private static final long serialVersionUID = -8781434495150074529L;
    protected static final String USER_REQUESTS = "page.userRequests";
    protected static final int ROWS_PER_PAGE = 5;
    @SpringBean
    protected UserRequestRestClient userRequestRestClient;
    @SpringBean
    protected BpmnProcessRestClient bpmnProcessRestClient;

    public Flowable(PageParameters parameters) {
        super(parameters, USER_REQUESTS);
        final WebMarkupContainer container = new WebMarkupContainer("content");
        this.contentWrapper.add(new Component[]{container.setOutputMarkupId(true)});
        final Model bpmnProcessModel = new Model();
        AjaxLink<Void> startButton = new AjaxLink<Void>(this, "start"){
            private static final long serialVersionUID = 3669569969172391336L;
            final /* synthetic */ Flowable this$0;
            {
                this.this$0 = this$0;
                super(id);
            }

            public void onClick(AjaxRequestTarget target) {
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)((Object)bpmnProcessModel.getObject())))) {
                    try {
                        this.this$0.userRequestRestClient.startRequest((String)((Object)bpmnProcessModel.getObject()));
                    }
                    catch (Exception e) {
                        LOG.error("Unable to start bpmnProcess [{}]", (Object)bpmnProcessModel.getObject(), (Object)e);
                        SyncopeEnduserSession.get().error((Serializable)((Object)String.format("Unable to start bpmnProcess [%s]", e.getMessage())));
                        this.this$0.notificationPanel.refresh((IPartialPageRequestHandler)target);
                    }
                    target.add(new Component[]{container});
                }
            }
        };
        container.add(new Component[]{startButton.setEnabled(false)});
        AjaxTextFieldPanel bpmnProcesses = new AjaxTextFieldPanel("bpmnProcesses", "bpmnProcesses", (IModel)bpmnProcessModel, false);
        bpmnProcesses.getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior(this, "change", (AjaxLink)startButton, bpmnProcessModel, container){
            private static final long serialVersionUID = -1107858522700306810L;
            final /* synthetic */ AjaxLink val$startButton;
            final /* synthetic */ Model val$bpmnProcessModel;
            final /* synthetic */ WebMarkupContainer val$container;
            final /* synthetic */ Flowable this$0;
            {
                this.val$startButton = ajaxLink;
                this.val$bpmnProcessModel = model;
                this.val$container = webMarkupContainer;
                this.this$0 = this$0;
                super(event);
            }

            protected void onUpdate(AjaxRequestTarget target) {
                this.val$startButton.setEnabled(StringUtils.isNotBlank((CharSequence)((CharSequence)((Object)this.val$bpmnProcessModel.getObject()))));
                target.add(new Component[]{this.val$container});
            }
        }});
        bpmnProcesses.setChoices(this.bpmnProcessRestClient.getDefinitions().stream().filter(Predicate.not(BpmnProcess::isUserWorkflow)).map(BpmnProcess::getKey).sorted().toList());
        container.add(new Component[]{bpmnProcesses});
        DataView<UserRequest> urDataView = new DataView<UserRequest>(this, "userRequests", (IDataProvider)new URDataProvider(5, "bpmnProcess")){
            private static final long serialVersionUID = -5002600396458362774L;
            final /* synthetic */ Flowable this$0;
            {
                this.this$0 = this$0;
                super(id, dataProvider);
            }

            protected void populateItem(Item<UserRequest> item) {
                final UserRequest userRequest = (UserRequest)item.getModelObject();
                item.add(new Component[]{new Accordion("userRequestDetails", List.of(new AbstractTab(this, (IModel)new StringResourceModel("user.requests.accordion", (Component)container, (IModel)Model.of((Serializable)userRequest))){
                    private static final long serialVersionUID = 1037272333056449378L;
                    final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                        super(title);
                    }

                    public WebMarkupContainer getPanel(String panelId) {
                        return new UserRequestDetails(panelId, userRequest, container, this.this$1.this$0.notificationPanel);
                    }
                }), (IModel)Model.of((Serializable)Integer.valueOf(-1))).setOutputMarkupId(true)});
            }
        };
        urDataView.setItemsPerPage(5L);
        container.add(new Component[]{urDataView.setOutputMarkupId(true)});
        container.add(new Component[]{new AjaxPagingNavigator("navigator", (IPageable)urDataView)});
    }

    protected class URDataProvider
    implements IDataProvider<UserRequest> {
        private static final long serialVersionUID = 1169386589403139714L;
        protected final int paginatorRows;
        protected final String sortParam;

        public URDataProvider(int paginatorRows, String sortParam) {
            this.paginatorRows = paginatorRows;
            this.sortParam = sortParam;
        }

        public Iterator<UserRequest> iterator(long first, long count) {
            int page = (int)first / this.paginatorRows;
            return Flowable.this.userRequestRestClient.listRequests((page < 0 ? 0 : page) + 1, this.paginatorRows, (SortParam<String>)new SortParam((Object)this.sortParam, true)).iterator();
        }

        public long size() {
            return Flowable.this.userRequestRestClient.countRequests();
        }

        public IModel<UserRequest> model(UserRequest ur) {
            return Model.of((Serializable)ur);
        }
    }
}

